/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.util;

import com.hypherionmc.simplerpc.jodd.io.IOUtil;
import com.hypherionmc.simplerpc.jodd.util.ClassUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class ResourcesUtil {
    public static URL getResourceUrl(String resourceName) {
        return ResourcesUtil.getResourceUrl(resourceName, null);
    }

    public static URL getResourceUrl(String resourceName, ClassLoader classLoader) {
        URL resourceUrl;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (classLoader != null && (resourceUrl = classLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader && (resourceUrl = currentThreadClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        Class callerClass = ClassUtil.getCallerClass(2);
        ClassLoader callerClassLoader = callerClass.getClassLoader();
        if (callerClassLoader != classLoader && callerClassLoader != currentThreadClassLoader && (resourceUrl = callerClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(String resourceName) throws IOException {
        InputStream inputStream = ResourcesUtil.getResourceAsStream(resourceName);
        try {
            char[] data = IOUtil.readChars(inputStream);
            String string = new String(data);
            return string;
        }
        finally {
            IOUtil.close(inputStream);
        }
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        return ResourcesUtil.getResourceAsStream(resourceName, null);
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass) throws IOException {
        URL url = ResourcesUtil.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass, boolean useCache) throws IOException {
        URL url = ResourcesUtil.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(useCache);
            return urlConnection.getInputStream();
        }
        return null;
    }
}

