/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.rpcsdk.connection;

import com.hypherionmc.simplerpc.rpcsdk.DiscordRpc;
import com.hypherionmc.simplerpc.rpcsdk.connection.MacOsConnection;
import com.hypherionmc.simplerpc.rpcsdk.connection.UnixConnection;
import com.hypherionmc.simplerpc.rpcsdk.connection.WindowsConnection;
import com.hypherionmc.simplerpc.rpcsdk.enums.OSType;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.NoDiscordClientException;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.PipeAccessDenied;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.UnsupportedOsType;
import com.hypherionmc.simplerpc.rpcsdk.utils.OSDetector;

public abstract class BaseConnection {
    private final DiscordRpc rpc;

    static BaseConnection createConnection(DiscordRpc rpc) throws UnsupportedOsType {
        OSType osType = OSDetector.INSTANCE.detectOs();
        if (osType.isWindows()) {
            return new WindowsConnection(rpc);
        }
        if (osType.isLinux()) {
            return new UnixConnection(rpc);
        }
        if (osType.isMac()) {
            return new MacOsConnection(rpc);
        }
        throw new UnsupportedOsType(osType);
    }

    static void destroyConnection(BaseConnection connection) {
        if (connection == null) {
            return;
        }
        connection.close();
    }

    abstract boolean isOpen();

    abstract boolean open() throws NoDiscordClientException, PipeAccessDenied;

    abstract void close();

    abstract boolean write(byte[] var1);

    abstract boolean read(byte[] var1, int var2);

    public abstract void register(String var1, String var2);

    public abstract void registerSteamGame(String var1, String var2);

    public DiscordRpc getRpc() {
        return this.rpc;
    }

    protected BaseConnection(DiscordRpc rpc) {
        this.rpc = rpc;
    }
}

