/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.rpcsdk.connection.unix;

import com.hypherionmc.simplerpc.rpcsdk.connection.unix.IUnixBackend;
import java.io.IOException;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class NIOUnixBackend
implements IUnixBackend {
    private SocketChannel channel;

    @Override
    public void openPipe(String path) throws IOException {
        this.channel = SocketChannel.open(UnixDomainSocketAddress.of(path));
    }

    @Override
    public void closePipe() throws IOException {
        if (this.channel == null) {
            return;
        }
        this.channel.close();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            return;
        }
        this.channel.write(ByteBuffer.wrap(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAvailable() throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            return -1;
        }
        Selector selector = Selector.open();
        try {
            this.channel.configureBlocking(false);
            this.channel.register(selector, 1);
            int n = selector.selectNow();
            return n;
        }
        finally {
            selector.close();
            try {
                if (this.channel.isOpen()) {
                    this.channel.configureBlocking(true);
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            return -1;
        }
        return this.channel.read(ByteBuffer.wrap(bytes));
    }

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }
}

