/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaColors.mixin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.TreeOfSelf.PandaColors.TextFormattingHelper;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5837;
import net.minecraft.class_8242;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2625.class})
public class SignBlockEntityMixin {
    @Inject(method={"setEditor"}, at={@At(value="HEAD")})
    private void handleEditingStart(UUID editor, CallbackInfo ci) {
        class_2625 self = (class_2625)this;
        if (self.method_10997() != null && !self.method_10997().method_8608() && editor != null) {
            class_3218 serverWorld = (class_3218)self.method_10997();
            class_3222 serverPlayer = (class_3222)serverWorld.method_18470(editor);
            boolean editingFront = self.method_49834((class_1657)serverPlayer);
            this.restoreForEditing(self, editingFront);
            serverPlayer.field_13987.method_14364((class_2596)self.method_38249());
        }
    }

    @Unique
    private void restoreForEditing(class_2625 self, boolean editingFront) {
        class_9323 components = self.method_58693();
        class_9279 customData = (class_9279)components.method_58694(class_9334.field_49628);
        if (customData != null) {
            String otherSideKey;
            String editingSideKey;
            class_2487 nbt = customData.method_57461();
            String string = editingSideKey = editingFront ? "panda_colors_original_front" : "panda_colors_original_back";
            if (nbt.method_10545(editingSideKey)) {
                this.restoreTextSide(self, nbt, editingSideKey, editingFront, true);
            }
            String string2 = otherSideKey = editingFront ? "panda_colors_original_back" : "panda_colors_original_front";
            if (nbt.method_10545(otherSideKey)) {
                this.restoreTextSide(self, nbt, otherSideKey, !editingFront, false);
            }
        }
    }

    @Unique
    private void restoreTextSide(class_2625 self, class_2487 nbt, String key, boolean front, boolean showOriginal) {
        String jsonString = (String)nbt.method_10558(key).get();
        JsonObject originalLines = JsonParser.parseString((String)jsonString).getAsJsonObject();
        class_8242 signText = self.method_49843(front);
        if (showOriginal) {
            for (int i = 0; i < 4; ++i) {
                String lineKey = "line_" + i;
                if (!originalLines.has(lineKey)) continue;
                String originalLine = originalLines.get(lineKey).getAsString();
                signText = signText.method_49857(i, (class_2561)class_2561.method_43470((String)originalLine));
            }
        } else {
            StringBuilder combinedText = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                String lineKey = "line_" + i;
                if (!originalLines.has(lineKey)) continue;
                String originalLine = originalLines.get(lineKey).getAsString();
                if (i > 0) {
                    combinedText.append("\n");
                }
                combinedText.append(originalLine);
            }
            class_2561 formattedCombined = TextFormattingHelper.formatTextWithCustomCodes(combinedText.toString());
            class_2561[] formattedLines = this.splitFormattedTextProperly(formattedCombined);
            for (int i = 0; i < 4; ++i) {
                signText = signText.method_49857(i, formattedLines[i]);
            }
        }
        self.method_49840(signText, front);
    }

    @Inject(method={"tryChangeText"}, at={@At(value="TAIL")})
    private void formatAndStoreSignText(class_1657 player, boolean front, List<class_5837> messages, CallbackInfo ci) {
        class_2625 self = (class_2625)this;
        if (self.method_10997() != null && !self.method_10997().method_8608()) {
            class_8242 signText = self.method_49843(front);
            JsonObject originalLines = new JsonObject();
            StringBuilder combinedText = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                class_2561 originalText = signText.method_49859(i, false);
                String originalString = originalText.getString();
                originalLines.addProperty("line_" + i, originalString);
                if (i > 0) {
                    combinedText.append("\n");
                }
                combinedText.append(originalString);
            }
            class_2561 formattedCombined = TextFormattingHelper.formatTextWithCustomCodes(combinedText.toString());
            class_2561[] formattedLines = this.splitFormattedTextProperly(formattedCombined);
            class_8242 formattedSignText = signText;
            for (int i = 0; i < 4; ++i) {
                formattedSignText = formattedSignText.method_49857(i, formattedLines[i]);
            }
            String key = front ? "panda_colors_original_front" : "panda_colors_original_back";
            class_9323 components = self.method_58693();
            class_9279 existingData = (class_9279)components.method_58694(class_9334.field_49628);
            class_2487 finalData = existingData != null ? existingData.method_57461() : new class_2487();
            finalData.method_10582(key, originalLines.toString());
            class_9323 newComponents = class_9323.method_57827().method_57839(components).method_57840(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)finalData)).method_57838();
            self.method_58684(newComponents);
            self.method_49840(formattedSignText, front);
        }
    }

    @Unique
    private class_2561[] splitFormattedTextProperly(class_2561 formattedText) {
        ArrayList<class_5250> lines = new ArrayList<class_5250>();
        class_5250[] currentLine = new class_5250[]{class_2561.method_43473()};
        formattedText.method_27658((style, string) -> {
            if (string.contains("\n")) {
                String[] parts = string.split("\n", -1);
                for (int i = 0; i < parts.length; ++i) {
                    if (i > 0) {
                        lines.add(currentLine[0]);
                        currentLine[0] = class_2561.method_43473();
                    }
                    if (parts[i].isEmpty()) continue;
                    currentLine[0].method_10852((class_2561)class_2561.method_43470((String)parts[i]).method_10862(style));
                }
            } else {
                currentLine[0].method_10852((class_2561)class_2561.method_43470((String)string).method_10862(style));
            }
            return Optional.empty();
        }, class_2583.field_24360);
        lines.add(currentLine[0]);
        class_2561[] result = new class_2561[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = i < lines.size() ? (class_2561)lines.get(i) : class_2561.method_43473();
        }
        return result;
    }
}

