/*
 * Decompiled with CFR 0.152.
 */
package ahud.adaptivehud;

import ahud.adaptivehud.AdaptiveHUD;
import ahud.adaptivehud.JsonValidator;
import ahud.adaptivehud.Tools;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.apache.commons.io.FileUtils;

public class ConfigFiles {
    public static List<JsonElement> elementArray = new ArrayList<JsonElement>();
    public static JsonElement configFile;

    private void generateConfigFile() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path targetPath = Paths.get(String.valueOf(configDir) + "/adaptivehud/config.json5", new String[0]);
        try {
            InputStream resource = ConfigFiles.class.getResourceAsStream("/assets/adaptivehud/premade/default_setup/config.json5");
            FileUtils.copyInputStreamToFile((InputStream)resource, (File)targetPath.toFile());
        }
        catch (Exception e) {
            AdaptiveHUD.LOGGER.error("AdaptiveHUD - Could not generate a new config.json5 file, the program will now close. This error should not normally occur, and if you need help, please join our discord server. This error indicates that there's something wrong with the jar file, or the program doesn't have access to write files.");
            AdaptiveHUD.LOGGER.error("Shutting down minecraft...");
            AdaptiveHUD.LOGGER.error(e.toString());
            class_310.method_1551().method_1490();
        }
    }

    private void generateElementFolder() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path targetDir = Paths.get(String.valueOf(configDir) + "/adaptivehud/elements", new String[0]);
        try {
            ZipEntry entry;
            InputStream resource = ConfigFiles.class.getResourceAsStream("/assets/adaptivehud/premade/default_setup/elements.zip");
            new File(targetDir.toUri()).mkdir();
            BufferedInputStream zipStream = new BufferedInputStream(resource);
            ZipInputStream zip = new ZipInputStream(zipStream);
            while ((entry = zip.getNextEntry()) != null) {
                String name = entry.getName();
                Path targetPath = targetDir.resolve(name);
                Files.copy(zip, targetPath, new CopyOption[0]);
            }
        }
        catch (Exception e) {
            AdaptiveHUD.LOGGER.error("AdaptiveHUD - Could not generate a new element folder, the program will now close. This error should not normally occur, and if you need help, please join our discord server. This error indicates that there's something wrong with the jar file, or the program doesn't have access to write files.");
            AdaptiveHUD.LOGGER.error("Shutting down minecraft...");
            AdaptiveHUD.LOGGER.error(e.toString());
            class_310.method_1551().method_1490();
        }
    }

    public void CheckDefaultConfigs() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        if (Files.notExists(configDir.resolve("adaptivehud"), new LinkOption[0])) {
            AdaptiveHUD.LOGGER.warn("Configuration folder not found - generating folder and example files.");
            new File(String.valueOf(configDir) + "/adaptivehud").mkdir();
            this.generateElementFolder();
            this.generateConfigFile();
        } else {
            if (Files.notExists(configDir.resolve("adaptivehud/config.json5"), new LinkOption[0])) {
                AdaptiveHUD.LOGGER.warn("Partially corrupted configuration setup found! Will now generate a new config file.");
                this.generateConfigFile();
            }
            if (Files.notExists(configDir.resolve("adaptivehud/elements"), new LinkOption[0])) {
                AdaptiveHUD.LOGGER.warn("Partially corrupted configuration setup found! Will now generate a new element folder with default files.");
                this.generateElementFolder();
            }
        }
    }

    public void GenerateElementArray() {
        elementArray.clear();
        File[] files = new File(String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/adaptivehud/elements").listFiles();
        int fails = 0;
        ArrayList<String> names = new ArrayList<String>();
        if (files != null) {
            boolean saveRepaired = false;
            for (File file : files) {
                try {
                    String validated;
                    FileReader fileReader = new FileReader(file);
                    JsonElement elm = JsonParser.parseReader((Reader)fileReader);
                    fileReader.close();
                    JsonElement repairedElm = new JsonValidator().repairElement(elm.deepCopy());
                    if (!repairedElm.equals(elm)) {
                        new Tools().sendToast("\u00a76Element Repaired!", "\u00a7f" + file.getName() + " was repaired!");
                        AdaptiveHUD.LOGGER.warn("Element " + file.getName() + " was partially corrupted, the element has now been repaired!");
                        saveRepaired = true;
                    }
                    if ((validated = new JsonValidator().validateElement(repairedElm.getAsJsonObject())) == null) {
                        String name = repairedElm.getAsJsonObject().get("name").getAsString();
                        if (names.contains(name.toLowerCase())) {
                            new Tools().sendToast("\u00a7c" + file.getName(), "\u00a7fKey name must be unique!");
                            AdaptiveHUD.LOGGER.error("Failed to load element file " + file.getName() + "! The identifier (\"name\" key) must be unique!");
                            ++fails;
                            continue;
                        }
                        elementArray.add(repairedElm);
                        names.add(name.toLowerCase());
                        continue;
                    }
                    AdaptiveHUD.LOGGER.error("Failed to load element file " + file.getName() + "! If you don't know what's wrong, please seek help in adaptivehud discord server! Error message: " + validated);
                    new Tools().sendToast("\u00a7c" + file.getName(), "\u00a7f" + validated);
                    ++fails;
                }
                catch (Exception e) {
                    AdaptiveHUD.LOGGER.error("Failed to load element file " + file.getName() + "! If you don't know what's wrong, please seek help in adaptivehud discord server! This might be caused by a missing comma or similar. This is most likely because of you having manually edited the file. Please use the in game editor if you don't know what you're doing. Error:");
                    AdaptiveHUD.LOGGER.error(String.valueOf(e));
                    ++fails;
                    new Tools().sendToast("\u00a7c" + file.getName(), "\u00a7fInvalid json format or similar!");
                }
            }
            if (saveRepaired) {
                this.saveElementFiles(elementArray, new ArrayList<String>());
            }
        } else {
            AdaptiveHUD.LOGGER.warn("No element files detected!");
            new Tools().sendToast("\u00a7cNo elements detected!", "\u00a7fNo elements were found.");
        }
        new Tools().sendToast("\u00a7aElements Reloaded!", "\u00a7e" + (files.length - fails) + "/" + files.length + " elements have successfully been reloaded.");
    }

    public void generateConfigArray() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        try {
            File config = new File(String.valueOf(configDir) + "/adaptivehud/config.json5");
            FileReader fileReader = new FileReader(config);
            JsonElement elm = JsonParser.parseReader((Reader)fileReader);
            fileReader.close();
            String validated = new JsonValidator().validateConfig(elm.getAsJsonObject());
            if (validated != null) {
                AdaptiveHUD.LOGGER.error(validated);
                AdaptiveHUD.LOGGER.error("[CRITICAL] - Configuration file could not be read properly. This is most likely because of a missing key or similar, the file does not follow the required format. For help, please seek help in adaptivehud discord server.");
                AdaptiveHUD.LOGGER.error("The game will now close because of the error above, invalid configuration file.");
                class_310.method_1551().method_1490();
                return;
            }
            configFile = elm;
        }
        catch (Exception e) {
            AdaptiveHUD.LOGGER.error("AdaptiveHUD - Could not load configuration file, this is most likely because of the file not following proper json syntax, like a missing comma or similar. For help, please seek help in adaptivehud discord server.");
            AdaptiveHUD.LOGGER.error(e.getMessage());
            class_310.method_1551().method_1490();
        }
    }

    public void saveElementFiles(List<JsonElement> elmArray, List<String> deletedFiles) {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        int fails = 0;
        for (String fileName : deletedFiles) {
            try {
                File delFile = new File(String.valueOf(configDir) + "/adaptivehud/elements/" + fileName + ".json");
                if (delFile.exists()) {
                    Files.delete(delFile.toPath());
                    continue;
                }
                AdaptiveHUD.LOGGER.warn("Could not delete element file " + fileName + ".json, because the file doesn't exist.");
                ++fails;
            }
            catch (Exception e) {
                AdaptiveHUD.LOGGER.error("Failed to delete element file " + fileName + ".json! For help, please join our discord. Error:");
                AdaptiveHUD.LOGGER.error(String.valueOf(e));
                new Tools().sendToast("\u00a7cFailed to delete file!", "\u00a7fCheck console for further information");
                ++fails;
            }
        }
        for (JsonElement elm : elmArray) {
            try {
                JsonObject obj = elm.getAsJsonObject();
                String fileName = obj.get("name").getAsString().toLowerCase() + ".json";
                File elmFile = new File(String.valueOf(configDir) + "/adaptivehud/elements/" + fileName);
                if (elmFile.exists()) {
                    FileReader fileReader = new FileReader(elmFile);
                    JsonElement parsed = JsonParser.parseReader((Reader)fileReader);
                    fileReader.close();
                    if (parsed.equals(elm)) continue;
                    FileWriter writer = new FileWriter(elmFile);
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    JsonWriter jsonWriter = gson.newJsonWriter((Writer)writer);
                    gson.toJson((JsonElement)obj, jsonWriter);
                    jsonWriter.flush();
                    continue;
                }
                Files.createDirectories(elmFile.getParentFile().toPath(), new FileAttribute[0]);
                FileWriter writer = new FileWriter(elmFile);
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                JsonWriter jsonWriter = gson.newJsonWriter((Writer)writer);
                gson.toJson((JsonElement)obj, jsonWriter);
                jsonWriter.flush();
            }
            catch (Exception e) {
                AdaptiveHUD.LOGGER.error("Error saving element file: " + e.getMessage());
                new Tools().sendToast("\u00a7cFailed to save file!", "\u00a7f" + e.getMessage());
                ++fails;
            }
        }
        new Tools().sendToast("\u00a7aChanges have been saved!", "\u00a7e" + fails + " errors encountered!");
    }
}

