/*
 * Decompiled with CFR 0.152.
 */
package ahud.adaptivehud;

import ahud.adaptivehud.Tools;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public class JsonValidator {
    public JsonElement repairElement(JsonElement elm) {
        JsonObject advanced;
        JsonObject requirement;
        JsonObject alignment;
        JsonObject background;
        JsonObject obj = elm.getAsJsonObject();
        if (!obj.has("enabled")) {
            obj.addProperty("enabled", Boolean.valueOf(true));
        }
        if (!obj.has("textColor")) {
            obj.addProperty("textColor", "#FFFFFF");
        }
        if (!obj.has("posX")) {
            obj.addProperty("posX", (Number)0);
        }
        if (!obj.has("posY")) {
            obj.addProperty("posY", (Number)0);
        }
        if (!obj.has("shadow")) {
            obj.addProperty("shadow", Boolean.valueOf(true));
        }
        if (!obj.has("background")) {
            obj.add("background", (JsonElement)new JsonObject());
        }
        if (!(background = obj.get("background").getAsJsonObject()).has("enabled")) {
            background.addProperty("enabled", Boolean.valueOf(false));
        }
        if (!background.has("paddingX")) {
            background.addProperty("paddingX", (Number)5);
        }
        if (!background.has("paddingY")) {
            background.addProperty("paddingY", (Number)5);
        }
        if (!background.has("backgroundColor")) {
            background.addProperty("backgroundColor", "#0000004c");
        }
        if (!obj.has("alignment")) {
            obj.add("alignment", (JsonElement)new JsonObject());
        }
        if (!(alignment = obj.get("alignment").getAsJsonObject()).has("anchorPointX")) {
            alignment.addProperty("anchorPointX", (Number)0);
        }
        if (!alignment.has("anchorPointY")) {
            alignment.addProperty("anchorPointY", (Number)0);
        }
        if (!alignment.has("textAlignX")) {
            alignment.addProperty("textAlignX", (Number)0);
        }
        if (!alignment.has("textAlignY")) {
            alignment.addProperty("textAlignY", (Number)0);
        }
        if (!obj.has("requirement")) {
            obj.add("requirement", (JsonElement)new JsonObject());
        }
        if (!(requirement = obj.get("requirement").getAsJsonObject()).has("renderRequirement")) {
            requirement.addProperty("renderRequirement", "");
        }
        if (!obj.has("advanced")) {
            obj.add("advanced", (JsonElement)new JsonObject());
        }
        if (!(advanced = obj.get("advanced").getAsJsonObject()).has("scale")) {
            advanced.addProperty("scale", (Number)0);
        }
        return elm;
    }

    public String validateElement(JsonObject elm) {
        Pattern colorReg = Pattern.compile("^#?([0-9A-Fa-f]{6})([0-9A-Fa-f]{2})?$");
        ArrayList<Integer> allowedPos = new ArrayList<Integer>(Arrays.asList(0, 1, 2));
        try {
            JsonObject background = elm.get("background").getAsJsonObject();
            JsonObject alignment = elm.get("alignment").getAsJsonObject();
            JsonObject advanced = elm.get("advanced").getAsJsonObject();
            JsonObject requirement = elm.get("requirement").getAsJsonObject();
            elm.get("enabled").getAsBoolean();
            elm.get("name").getAsString();
            elm.get("posX").getAsInt();
            elm.get("posY").getAsInt();
            elm.get("shadow").getAsBoolean();
            background.get("enabled").getAsBoolean();
            background.get("paddingX").getAsInt();
            background.get("paddingY").getAsInt();
            requirement.get("renderRequirement").getAsString();
            if (!colorReg.matcher(elm.get("textColor").getAsString()).find() || !colorReg.matcher(background.get("backgroundColor").getAsString()).find()) {
                return "Invalid color!";
            }
            if (!(allowedPos.contains(alignment.get("anchorPointX").getAsInt()) && allowedPos.contains(alignment.get("anchorPointY").getAsInt()) && allowedPos.contains(alignment.get("textAlignX").getAsInt()) && allowedPos.contains(alignment.get("textAlignY").getAsInt()))) {
                return "Invalid alignment!";
            }
            if (!(advanced.get("scale").getAsFloat() >= 0.0f) || !(advanced.get("scale").getAsFloat() < 10.0f)) {
                return "Invalid scale!";
            }
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String validateConfig(JsonObject elm) {
        try {
            double default_size = elm.get("default_size").getAsDouble();
            if (!(default_size > 0.1) || !(default_size < 10.0)) {
                return "Default size must be \"0.1 > default size < 10\".";
            }
            elm.get("render_on_debug").getAsBoolean();
            elm.get("render_get_help_button").getAsBoolean();
            elm.get("max_target_block_distance").getAsDouble();
            elm.get("variable_reload_cooldown").getAsInt();
            if (new Tools().parseColor(elm.get("snapping_lines_color").getAsString()) == 0 || new Tools().parseColor(elm.get("anchor_point_lines_color").getAsString()) == 0) {
                return "Invalid color in config file!";
            }
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

