/*
 * Decompiled with CFR 0.152.
 */
package ahud.adaptivehud.renderhud;

import ahud.adaptivehud.AdaptiveHUD;
import ahud.adaptivehud.ConfigFiles;
import ahud.adaptivehud.Tools;
import ahud.adaptivehud.renderhud.CoordCalculators;
import ahud.adaptivehud.renderhud.variables.ValueParser;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

public class RenderHUD {
    private long lastAdvancedUpdate = 0L;
    private final boolean USE_VALUE;
    private final int RELOAD_COOLDOWN = ConfigFiles.configFile.getAsJsonObject().get("variable_reload_cooldown").getAsInt();

    public RenderHUD(boolean useValue) {
        this.USE_VALUE = useValue;
    }

    public void renderCustomHud(class_332 drawContext) {
        if (!AdaptiveHUD.renderElements && this.USE_VALUE) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (!ConfigFiles.configFile.getAsJsonObject().get("render_on_debug").getAsBoolean() && client.field_1705.method_53531().method_53536()) {
            return;
        }
        if (this.USE_VALUE) {
            AdaptiveHUD.complexVARS.generateCommon();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastAdvancedUpdate > (long)this.RELOAD_COOLDOWN) {
                AdaptiveHUD.complexVARS.generateCooldowned();
                this.lastAdvancedUpdate = currentTime;
            }
        }
        ValueParser parser = new ValueParser();
        Matrix3x2fStack matrices = drawContext.method_51448();
        for (JsonElement element : ConfigFiles.elementArray) {
            int posY;
            int posX;
            String parsedText;
            JsonObject x = element.getAsJsonObject();
            if (!x.get("enabled").getAsBoolean()) continue;
            if (this.USE_VALUE) {
                String renderReq = x.get("requirement").getAsJsonObject().get("renderRequirement").getAsString();
                if (!renderReq.isEmpty()) {
                    int render = parser.renderCheck(renderReq);
                    if (render == -1) {
                        parsedText = class_2561.method_43471((String)"adaptivehud.variable.render_req_error").getString();
                    } else {
                        if (render == 0) continue;
                        parsedText = parser.parseValue(x.get("value").getAsString());
                    }
                } else {
                    parsedText = parser.parseValue(x.get("value").getAsString());
                }
            } else {
                parsedText = x.get("name").getAsString();
            }
            ArrayList<String> texts = new ArrayList<String>(Arrays.asList(parsedText.split("(?<!\\\\)\\\\n")));
            texts.removeAll(Collections.singleton(""));
            if (texts.isEmpty()) continue;
            ArrayList<Integer> widths = new ArrayList<Integer>();
            for (String text : texts) {
                widths.add(client.field_1772.method_1727(text));
            }
            int maxWidth = (Integer)Collections.max(widths);
            int paddingY = 0;
            int paddingX = 0;
            matrices.pushMatrix();
            float setScale = x.get("advanced").getAsJsonObject().get("scale").getAsFloat();
            float trueScale = 1.0f;
            if (setScale != 0.0f) {
                float defaultScale = setScale;
                float itemHeight = 9 + x.get("background").getAsJsonObject().get("paddingY").getAsInt() * 2;
                int wantedHeight = Math.round(itemHeight * defaultScale);
                trueScale = (float)wantedHeight / itemHeight;
                matrices.scale(trueScale, trueScale);
            } else {
                trueScale = ConfigFiles.configFile.getAsJsonObject().get("default_size").getAsFloat();
                matrices.scale(trueScale, trueScale);
            }
            Tools tools = new Tools();
            if (x.get("background").getAsJsonObject().get("enabled").getAsBoolean()) {
                paddingX = x.get("background").getAsJsonObject().get("paddingX").getAsInt();
                paddingY = x.get("background").getAsJsonObject().get("paddingY").getAsInt();
                posX = new CoordCalculators().getActualCords(element.getAsJsonObject(), x.get("posX").getAsInt(), client.method_22683().method_4486(), maxWidth + paddingX * 2, trueScale, "X");
                posY = new CoordCalculators().getActualCords(element.getAsJsonObject(), x.get("posY").getAsInt(), client.method_22683().method_4502(), texts.size() * 11 - 2 + Math.round(paddingY * 2), trueScale, "Y");
                drawContext.method_25294(posX, posY, posX + maxWidth + 2 * paddingX, posY + texts.size() * 11 - 2 + Math.round(2 * paddingY), tools.parseColor(x.get("background").getAsJsonObject().get("backgroundColor").getAsString()));
            } else {
                posX = new CoordCalculators().getActualCords(element.getAsJsonObject(), x.get("posX").getAsInt(), client.method_22683().method_4486(), maxWidth, trueScale, "X");
                posY = new CoordCalculators().getActualCords(element.getAsJsonObject(), x.get("posY").getAsInt(), client.method_22683().method_4502(), texts.size() * 11 - 2, trueScale, "Y");
            }
            int extra = 0;
            for (String text : texts) {
                drawContext.method_51433(client.field_1772, text, posX + paddingX, posY + paddingY + extra + 1, tools.parseColor(x.get("textColor").getAsString()), x.get("shadow").getAsBoolean());
                extra += 11;
            }
            matrices.popMatrix();
        }
    }

    public List<Object[]> generatePositions() {
        ArrayList<Object[]> positionList = new ArrayList<Object[]>();
        class_310 client = class_310.method_1551();
        for (JsonElement element : ConfigFiles.elementArray) {
            float defaultScale = ConfigFiles.configFile.getAsJsonObject().get("default_size").getAsFloat();
            JsonObject x = element.getAsJsonObject();
            if (!x.get("enabled").getAsBoolean()) continue;
            String parsedText = x.get("name").getAsString();
            int paddingY = 0;
            int paddingX = 0;
            float setScale = x.get("advanced").getAsJsonObject().get("scale").getAsFloat();
            if (setScale != 0.0f) {
                defaultScale = setScale;
            }
            if (x.get("background").getAsJsonObject().get("enabled").getAsBoolean()) {
                paddingX = x.get("background").getAsJsonObject().get("paddingX").getAsInt();
                paddingY = x.get("background").getAsJsonObject().get("paddingY").getAsInt();
            }
            int boxWidth = Math.round((float)(client.field_1772.method_1727(parsedText) + paddingX * 2) * defaultScale);
            int boxHeight = Math.round((float)(9 + paddingY * 2) * defaultScale);
            int posX = new CoordCalculators().getActualCords(element.getAsJsonObject(), x.get("posX").getAsInt(), client.method_22683().method_4486(), boxWidth, 0.0f, "X");
            int posY = new CoordCalculators().getActualCords(element.getAsJsonObject(), x.get("posY").getAsInt(), client.method_22683().method_4502(), boxHeight, 0.0f, "Y");
            Object[] sublist = new Object[]{element, posX, posY, posX + boxWidth, posY + boxHeight};
            positionList.add(sublist);
        }
        return positionList;
    }
}

