/*
 * Decompiled with CFR 0.152.
 */
package ahud.adaptivehud.renderhud.variables;

import ahud.adaptivehud.renderhud.variables.FlagTools;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;

public class FlagParser {
    private FlagTools tools = new FlagTools();

    public String parseFlags(String value, HashMap<String, String[]> flags) {
        for (Map.Entry<String, String[]> entry : flags.entrySet()) {
            String K = entry.getKey();
            String[] Vs = entry.getValue();
            if (Vs != null) {
                try {
                    switch (K) {
                        case "round": {
                            value = this.tools.roundNum(Float.parseFloat(value), Integer.parseInt(Vs[0]));
                            break;
                        }
                        case "replace": {
                            value = value.replaceAll(Vs[0], Vs[1]);
                            break;
                        }
                        case "split": {
                            value = value.split(Vs[0])[Integer.parseInt(Vs[1])];
                            break;
                        }
                        case "substring": {
                            value = Vs.length == 2 ? value.substring(Integer.parseInt(Vs[0]), Integer.parseInt(Vs[1])) : value.substring(Integer.parseInt(Vs[0]));
                            break;
                        }
                        case "contains": {
                            value = String.valueOf(value.contains(Vs[0]));
                            break;
                        }
                        case "charat": {
                            value = String.valueOf(value.charAt(Integer.parseInt(Vs[0])));
                        }
                    }
                }
                catch (Exception exception) {}
                continue;
            }
            switch (K) {
                case "uc": {
                    value = value.toUpperCase();
                    break;
                }
                case "lc": {
                    value = value.toLowerCase();
                    break;
                }
                case "tc": {
                    value = WordUtils.capitalizeFully((String)value);
                    break;
                }
                case "nd": {
                    value = value.replaceAll("[-_]", " ");
                    break;
                }
                case "sh": {
                    value = value.split(":")[1];
                    break;
                }
                case "length": {
                    value = String.valueOf(value.length());
                }
            }
        }
        return value;
    }
}

