/*
 * Decompiled with CFR 0.152.
 */
package ahud.adaptivehud.renderhud.variables;

import ahud.adaptivehud.AdaptiveHUD;
import ahud.adaptivehud.renderhud.variables.FlagParser;
import ahud.adaptivehud.renderhud.variables.annotations.SetDefaultGlobalFlag;
import ahud.adaptivehud.renderhud.variables.annotations.SetDefaultGlobalFlagCont;
import ahud.adaptivehud.renderhud.variables.annotations.SpecialFlagName;
import com.udojava.evalex.Expression;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;

public class ValueParser {
    public String parseValue(String text) {
        text = text.replaceAll("&(?=[\\da-fA-Fk-oK-OrR])", "\u00a7");
        text = this.parseVariables(text);
        text = this.parseConditions(text);
        text = this.parseMath(text);
        return text;
    }

    public int renderCheck(String text) {
        try {
            text = this.parseVariables(text);
            return !this.parseBooleanExpression(text) ? 0 : 1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String parseConditions(String text) {
        Pattern pattern = Pattern.compile("\\[((?:[^:\\[\\],\\\\]|\\\\.)+):((?:[^:\\[\\],\\\\]|\\\\.)+)((?:,(?:[^:\\[\\],\\\\]|\\\\.)+:(?:[^:\\[\\],\\\\]|\\\\.)+)*)(?:,((?:[^:\\[\\],\\\\]|\\\\.)+))?]");
        Matcher matcher = pattern.matcher(text);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            try {
                String ifCondition = matcher.group(1);
                String ifValue = matcher.group(2);
                String elseIfs = matcher.group(3);
                String elseValue = matcher.group(4);
                if (elseValue == null) {
                    elseValue = "";
                }
                if (this.parseBooleanExpression(ifCondition)) {
                    matcher.appendReplacement(result, ifValue.replaceAll("\\\\n", "\\\\\\\\n"));
                    continue;
                }
                boolean found = false;
                if (!elseIfs.isEmpty()) {
                    for (String x : elseIfs.substring(1).split("(?<!\\\\),")) {
                        String[] conVal = x.split("(?<!\\\\):");
                        if (!this.parseBooleanExpression(conVal[0])) continue;
                        matcher.appendReplacement(result, conVal[1].replaceAll("\\\\n", "\\\\\\\\n"));
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                matcher.appendReplacement(result, elseValue.replaceAll("\\\\n", "\\\\\\\\n"));
            }
            catch (Exception e) {
                matcher.appendReplacement(result, class_2561.method_43471((String)"adaptivehud.variable.condition_error").getString());
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String parseVariables(String text) {
        Pattern pattern = Pattern.compile("\\{(\\w+)+((?: *-[a-zA-Z]+(?:=(?:[^:{}=\\-\\\\]|\\\\.)+)?)*)((?: *--[a-zA-Z]+(?:=(?:[^:{}=\\-\\\\]|\\\\.)+)?)*)}");
        Matcher matcher = pattern.matcher(text);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String varName = matcher.group(1);
            try {
                void var13_25;
                Method method = AdaptiveHUD.variableRegister.loadVariable(varName);
                if (method == null) continue;
                String globalFlagString = matcher.group(2).replaceAll(" ", "");
                String flagString = matcher.group(3).replaceAll(" ", "");
                HashMap<String, String[]> flags = new HashMap<String, String[]>();
                if (!globalFlagString.isEmpty()) {
                    for (String string : globalFlagString.split(" *-")) {
                        if (string.contains("=")) {
                            String[] valueFlag = string.split("=");
                            flags.put(valueFlag[0], valueFlag[1].split("(?<!\\\\);"));
                            continue;
                        }
                        flags.put(string, null);
                    }
                }
                if (method.isAnnotationPresent(SetDefaultGlobalFlag.class)) {
                    SetDefaultGlobalFlag[] annFlag = method.getAnnotation(SetDefaultGlobalFlag.class);
                    if (!flags.containsKey(annFlag.flag())) {
                        flags.put(annFlag.flag(), annFlag.values());
                    }
                } else if (method.isAnnotationPresent(SetDefaultGlobalFlagCont.class)) {
                    for (SetDefaultGlobalFlag setDefaultGlobalFlag : method.getAnnotation(SetDefaultGlobalFlagCont.class).value()) {
                        if (flags.containsKey(setDefaultGlobalFlag.flag())) continue;
                        flags.put(setDefaultGlobalFlag.flag(), setDefaultGlobalFlag.values());
                    }
                }
                HashMap<String, String> localFlags = new HashMap<String, String>();
                if (!flagString.isEmpty()) {
                    void var13_23;
                    String[] stringArray = flagString.split("--");
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var13_23 < n) {
                        String flag = stringArray[var13_23];
                        if (flag.contains("=")) {
                            String[] values = flag.split("=");
                            localFlags.put(values[0], values[1]);
                        } else {
                            localFlags.put(flag, null);
                        }
                        ++var13_23;
                    }
                }
                Parameter[] params = method.getParameters();
                Object[] parameters = new Object[params.length];
                boolean bl = false;
                while (var13_25 < params.length) {
                    String keyName;
                    Parameter param = params[var13_25];
                    if (param.isAnnotationPresent(SpecialFlagName.class) && localFlags.containsKey(keyName = param.getAnnotation(SpecialFlagName.class).value())) {
                        boolean paramBoolean;
                        boolean bl2 = paramBoolean = param.getType() == Boolean.class;
                        parameters[var13_25] = localFlags.get(keyName) != null ? (paramBoolean ? Boolean.valueOf(false) : localFlags.get(keyName)) : (paramBoolean ? Boolean.valueOf(true) : "1");
                    }
                    ++var13_25;
                }
                String string2 = String.valueOf(method.invoke(method.getDeclaringClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), parameters));
                string2 = new FlagParser().parseFlags(string2, flags);
                matcher.appendReplacement(result, string2);
            }
            catch (Exception e) {
                matcher.appendReplacement(result, class_2561.method_43471((String)"adaptivehud.variable.variable_error").getString());
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String parseMath(String text) {
        Pattern mathPattern = Pattern.compile("%([\\d+\\-*/^ a-z]*)%");
        Matcher mathMatcher = mathPattern.matcher(text);
        StringBuilder mathResult = new StringBuilder();
        while (mathMatcher.find()) {
            try {
                Expression exp = new Expression(mathMatcher.group(1));
                BigDecimal replacement = exp.eval();
                mathMatcher.appendReplacement(mathResult, String.valueOf(replacement));
            }
            catch (Exception e) {
                mathMatcher.appendReplacement(mathResult, class_2561.method_43471((String)"adaptivehud.variable.math_error").getString());
            }
        }
        mathMatcher.appendTail(mathResult);
        return mathResult.toString();
    }

    private boolean parseBooleanExpression(String expression) {
        Pattern stringPattern = Pattern.compile("\"([^\"]+)\"(?: *== *\"([^\"]+)\")?");
        Matcher stringMatcher = stringPattern.matcher(expression.replaceAll("(\"null\"|\"false\"|\"Empty\")", "false"));
        StringBuilder stringResult = new StringBuilder();
        while (stringMatcher.find()) {
            if (stringMatcher.group(2) != null) {
                stringMatcher.appendReplacement(stringResult, String.valueOf(stringMatcher.group(1).equals(stringMatcher.group(2))));
                continue;
            }
            stringMatcher.appendReplacement(stringResult, String.valueOf(!stringMatcher.group(1).isEmpty()));
        }
        stringMatcher.appendTail(stringResult);
        Expression expression_fr = new Expression(stringResult.toString());
        return expression_fr.eval().intValue() != 0;
    }
}

