/*
 * Decompiled with CFR 0.152.
 */
package ahud.adaptivehud.renderhud.variables;

import ahud.adaptivehud.AdaptiveHUD;
import ahud.adaptivehud.renderhud.variables.inbuilt_variables.DefaultVariables;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class VariableRegisterer {
    private static final Map<String, Method> VARIABLE_LIST = new HashMap<String, Method>();

    public void registerVariable(String name, Method method) {
        VARIABLE_LIST.put(name, method);
    }

    public Method loadVariable(String name) {
        try {
            return VARIABLE_LIST.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void registerDefaults() {
        try {
            for (Method method : DefaultVariables.class.getDeclaredMethods()) {
                this.registerVariable(method.getName(), method);
            }
        }
        catch (Exception e) {
            AdaptiveHUD.LOGGER.error("Failed to register a default variable!");
            AdaptiveHUD.LOGGER.error(e.toString());
        }
    }

    public void deleteVariables() {
        VARIABLE_LIST.clear();
    }
}

