/*
 * Decompiled with CFR 0.152.
 */
package ahud.adaptivehud.screens.configscreen;

import ahud.adaptivehud.AdaptiveHUD;
import ahud.adaptivehud.ConfigFiles;
import ahud.adaptivehud.screens.configscreen.ScrollableList;
import ahud.adaptivehud.screens.movescreen.MoveScreen;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.apache.commons.io.IOUtils;

@Environment(value=EnvType.CLIENT)
public class ConfigScreen
extends class_437 {
    private final class_437 PARENT;
    private final List<JsonElement> BACKUP_ELEMENT_ARR = new ArrayList<JsonElement>();
    private final List<String> DELETED_FILES = new ArrayList<String>();
    private final class_2960 DISCORD_TEXTURE = class_2960.method_60655((String)"adaptivehud", (String)"textures/gui/discord_logo.png");
    private static final class_2561 DISCORD_TEXT = class_2561.method_43471((String)"adaptivehud.config.discordText");
    private static final class_2561 DEFAULT_NAME = class_2561.method_43471((String)"adaptivehud.config.defaultName");
    private final boolean renderDiscordButton = ConfigFiles.configFile.getAsJsonObject().get("render_get_help_button").getAsBoolean();
    private ScrollableList scrollableList;
    private Boolean fileChanged = false;
    private int discordWidth;

    public ConfigScreen(class_437 parent) {
        super(class_2561.method_30163((String)"AdaptiveHUD"));
        this.PARENT = parent;
        for (JsonElement elm : ConfigFiles.elementArray) {
            this.BACKUP_ELEMENT_ARR.add(elm.deepCopy());
        }
    }

    protected void method_25426() {
        this.discordWidth = this.field_22793.method_27525((class_5348)DISCORD_TEXT) + 16 + 5 + 3 + 5;
        class_4185 newElm = class_4185.method_46430((class_2561)class_2561.method_43471((String)"adaptivehud.config.createNewElement"), btn -> this.createNewElement()).method_46434(this.field_22789 / 16, 50, this.field_22789 / 8 * 3, 20).method_46431();
        this.method_37063((class_364)newElm);
        class_4185 moveElements = class_4185.method_46430((class_2561)class_2561.method_43471((String)"adaptivehud.config.moveElements"), btn -> this.moveElements()).method_46434(this.field_22789 / 16, 75, this.field_22789 / 8 * 3, 20).method_46431();
        this.method_37063((class_364)moveElements);
        class_4185 reloadElements = class_4185.method_46430((class_2561)class_2561.method_43471((String)"adaptivehud.config.reloadElements"), btn -> this.reloadElements()).method_46434(this.field_22789 / 16, 100, this.field_22789 / 8 * 3 / 3 * 2 - 5, 20).method_46431();
        this.method_37063((class_364)reloadElements);
        class_4185 folderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"adaptivehud.config.folder"), btn -> this.openFolder()).method_46434(this.field_22789 / 16 + this.field_22789 / 8 * 3 / 3 * 2 - 5 + 5, 100, this.field_22789 / 8 * 3 / 3, 20).method_46431();
        this.method_37063((class_364)folderButton);
        class_4185 closeElm = class_4185.method_46430((class_2561)class_2561.method_43471((String)"adaptivehud.config.cancel"), btn -> this.discardChanges()).method_46434(this.field_22789 / 16, this.field_22790 - 50, this.field_22789 / 16 * 3 - 3, 20).method_46431();
        this.method_37063((class_364)closeElm);
        class_4185 saveAndExitElm = class_4185.method_46430((class_2561)class_2561.method_43471((String)"adaptivehud.config.done"), btn -> this.saveAndExit()).method_46434(this.field_22789 / 4 + 3, this.field_22790 - 50, this.field_22789 / 16 * 3 - 3, 20).method_46431();
        this.method_37063((class_364)saveAndExitElm);
        if (this.renderDiscordButton) {
            class_4185 discordButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), btn -> this.openDiscord()).method_46434(this.field_22789 - this.discordWidth - 10, 20, this.discordWidth, 20).method_46431();
            this.method_37063((class_364)discordButton);
        }
        this.scrollableList = new ScrollableList(this.field_22787, this.field_22790, this.field_22789, this);
        this.method_37063((class_364)this.scrollableList);
        this.changesMade();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25300(this.field_22793, "AdaptiveHUD", this.field_22789 / 2, 20, -1);
        if (this.renderDiscordButton) {
            context.method_25290(class_10799.field_56883, this.DISCORD_TEXTURE, this.field_22789 - this.discordWidth - 5, 23, 0.0f, 0.0f, 14, 14, 14, 14);
            context.method_51439(this.field_22793, DISCORD_TEXT, this.field_22789 - this.discordWidth + 14, 26, -1, true);
        }
    }

    public boolean method_25406(class_11909 click) {
        super.method_25406(click);
        this.method_25395(null);
        return true;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.PARENT);
    }

    public boolean method_25422() {
        return this.fileChanged == false;
    }

    private void createNewElement() {
        try {
            InputStream resource = ConfigFiles.class.getResourceAsStream("/assets/adaptivehud/premade/new_element.json");
            String jsonContent = IOUtils.toString((InputStream)resource, (String)"UTF-8");
            JsonElement newElement = JsonParser.parseString((String)jsonContent);
            JsonObject newObject = newElement.getAsJsonObject();
            Object newName = DEFAULT_NAME.getString().toLowerCase();
            int counter = 1;
            while (ConfigFiles.elementArray.toString().contains("\"name\":\"" + (String)newName + "\",")) {
                newName = DEFAULT_NAME.getString().toLowerCase() + counter;
                ++counter;
            }
            newObject.addProperty("name", (String)newName);
            ConfigFiles.elementArray.add(newElement);
            this.scrollableList.updateEntries();
            this.changesMade();
        }
        catch (Exception e) {
            AdaptiveHUD.LOGGER.error("Failed to create new element!");
            AdaptiveHUD.LOGGER.error(e.getMessage());
        }
    }

    private void discardChanges() {
        ConfigFiles.elementArray = this.BACKUP_ELEMENT_ARR;
        this.method_25419();
    }

    private void saveAndExit() {
        if (this.fileChanged.booleanValue()) {
            new ConfigFiles().saveElementFiles(ConfigFiles.elementArray, this.DELETED_FILES);
        }
        this.method_25419();
    }

    private void reloadElements() {
        new ConfigFiles().GenerateElementArray();
        this.BACKUP_ELEMENT_ARR.clear();
        for (JsonElement elm : ConfigFiles.elementArray) {
            this.BACKUP_ELEMENT_ARR.add(elm.deepCopy());
        }
        this.scrollableList.updateEntries();
    }

    private void moveElements() {
        class_310.method_1551().method_1507((class_437)new MoveScreen(this, false));
    }

    public void changesMade() {
        this.fileChanged = !ConfigFiles.elementArray.equals(this.BACKUP_ELEMENT_ARR);
        class_4185 reloadElementsElm = (class_4185)this.method_25396().get(2);
        class_4185 saveButtonElm = (class_4185)this.method_25396().get(5);
        class_4185 cancelButtonElm = (class_4185)this.method_25396().get(4);
        reloadElementsElm.field_22763 = this.fileChanged == false;
        reloadElementsElm.method_47400(this.fileChanged != false ? class_7919.method_47407((class_2561)class_2561.method_43471((String)"adaptivehud.config.unsavedChanges")) : null);
        cancelButtonElm.field_22763 = this.fileChanged;
        cancelButtonElm.method_47400(this.fileChanged != false ? class_7919.method_47407((class_2561)class_2561.method_43471((String)"adaptivehud.config.cancelWarning")) : null);
        saveButtonElm.method_25355((class_2561)class_2561.method_43471((String)("adaptivehud.config." + (this.fileChanged != false ? "save" : "done"))));
    }

    public void deleteElement(JsonElement element) {
        ConfigFiles.elementArray.remove(element);
        String deleted_file_name = element.getAsJsonObject().get("name").getAsString();
        this.addDeletedFile(deleted_file_name);
        this.scrollableList.updateEntries();
        this.changesMade();
    }

    private void openDiscord() {
        try {
            class_156.method_668().method_670("https://discord.gg/tqn38v6w7k");
            AdaptiveHUD.LOGGER.info("Opening discord support server invite link in browser... (https://discord.gg/tqn38v6w7k)");
        }
        catch (Exception e) {
            AdaptiveHUD.LOGGER.error("Failed to open discord link! Link: https://discord.gg/tqn38v6w7k");
            AdaptiveHUD.LOGGER.error(String.valueOf(e));
        }
    }

    private void openFolder() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        File folder = new File(String.valueOf(configDir) + "/adaptivehud");
        class_156.method_668().method_672(folder);
    }

    public void addDeletedFile(String oldFileName) {
        if (!this.DELETED_FILES.contains(oldFileName) && this.BACKUP_ELEMENT_ARR.toString().contains("\"name\":\"" + oldFileName + "\",")) {
            this.DELETED_FILES.add(oldFileName);
        }
    }
}

