/*
 * Decompiled with CFR 0.152.
 */
package ahud.adaptivehud.screens.elementscreen;

import ahud.adaptivehud.AdaptiveHUD;
import ahud.adaptivehud.ConfigFiles;
import ahud.adaptivehud.JsonValidator;
import ahud.adaptivehud.Tools;
import ahud.adaptivehud.screens.configscreen.ConfigScreen;
import ahud.adaptivehud.screens.elementscreen.ScrollableArea;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ElementScreen
extends class_437 {
    private final class_437 PARENT;
    private final JsonElement BEFORE_EDITING;
    private static final String LEFT = class_2561.method_43471((String)"adaptivehud.config.button.left").getString();
    private static final String RIGHT = class_2561.method_43471((String)"adaptivehud.config.button.right").getString();
    private static final String TOP = class_2561.method_43471((String)"adaptivehud.config.button.top").getString();
    private static final String BOTTOM = class_2561.method_43471((String)"adaptivehud.config.button.bottom").getString();
    private static final String DOC_TEXT = class_2561.method_43471((String)"adaptivehud.config.documentation").getString();
    private ScrollableArea scrollableArea;
    public JsonObject elm;

    public ElementScreen(class_437 parent, JsonElement elm) {
        super(class_2561.method_30163((String)"AdaptiveHUD"));
        this.PARENT = parent;
        this.elm = elm.deepCopy().getAsJsonObject();
        this.BEFORE_EDITING = elm.deepCopy();
    }

    protected void method_25426() {
        class_4185 cancelBtn = class_4185.method_46430((class_2561)class_2561.method_43471((String)"adaptivehud.config.cancel"), btn -> this.method_25419()).method_46434(this.field_22789 / 2 - 105, this.field_22790 - 35, 100, 20).method_46431();
        this.method_37063((class_364)cancelBtn);
        class_4185 saveBtn = class_4185.method_46430((class_2561)class_2561.method_43471((String)"adaptivehud.config.save"), btn -> this.saveChanges()).method_46434(this.field_22789 / 2 + 5, this.field_22790 - 35, 100, 20).method_46431();
        this.method_37063((class_364)saveBtn);
        class_4185 documentationButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)DOC_TEXT), btn -> this.openDocumentation()).method_46434(this.field_22789 - this.field_22793.method_1727(DOC_TEXT) - 10 - 10, 20, this.field_22793.method_1727(DOC_TEXT) + 10, 20).method_46431();
        this.method_37063((class_364)documentationButton);
        this.scrollableArea = new ScrollableArea(this.field_22790, this.field_22789, this);
        this.method_25429((class_364)this.scrollableArea);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.scrollableArea.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25406(class_11909 click) {
        super.method_25406(click);
        return true;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.PARENT);
    }

    public boolean method_25422() {
        return false;
    }

    public boolean method_25400(class_11905 input) {
        if (this.scrollableArea.method_25400(input)) {
            return true;
        }
        return super.method_25400(input);
    }

    public boolean method_25404(class_11908 input) {
        if (this.scrollableArea.method_25404(input)) {
            return true;
        }
        return super.method_25404(input);
    }

    private void saveChanges() {
        for (ScrollableArea.Entry x : this.scrollableArea.method_25396()) {
            if (x.title != null) continue;
            JsonObject specElm = x.setting.equals("enabled") || x.setting.equals("paddingX") || x.setting.equals("paddingY") || x.setting.equals("backgroundColor") ? this.elm.get("background").getAsJsonObject() : (x.setting.equals("anchorPointX") || x.setting.equals("anchorPointY") || x.setting.equals("textAlignX") || x.setting.equals("textAlignY") ? this.elm.get("alignment").getAsJsonObject() : (x.setting.equals("renderRequirement") ? this.elm.get("requirement").getAsJsonObject() : (x.setting.equals("scale") ? this.elm.get("advanced").getAsJsonObject() : this.elm)));
            if (x.textField != null) {
                if (x.setting.equals("posX") || x.setting.equals("posY") || x.setting.equals("paddingX") || x.setting.equals("paddingY")) {
                    try {
                        specElm.addProperty(x.setting, (Number)Integer.parseInt(x.textField.method_1882()));
                    }
                    catch (Exception e) {
                        specElm.addProperty(x.setting, x.textField.method_1882());
                    }
                } else if (x.setting.equals("scale")) {
                    try {
                        specElm.addProperty(x.setting, (Number)Float.valueOf(x.textField.method_1882()));
                    }
                    catch (Exception e) {
                        specElm.addProperty(x.setting, x.textField.method_1882());
                    }
                } else if (x.setting.equals("name")) {
                    specElm.addProperty(x.setting, x.textField.method_1882().toLowerCase());
                } else {
                    specElm.addProperty(x.setting, x.textField.method_1882());
                }
            }
            if (x.button == null) continue;
            if (x.setting.equals("shadow") || x.setting.equals("enabled")) {
                specElm.addProperty(x.setting, Boolean.valueOf(x.button.method_25369().getString().equals(class_2561.method_43471((String)"adaptivehud.config.button.on").getString())));
                continue;
            }
            if (!x.setting.equals("anchorPointX") && !x.setting.equals("anchorPointY") && !x.setting.equals("textAlignX") && !x.setting.equals("textAlignY")) continue;
            String value = x.button.method_25369().getString();
            int corN = 1;
            if (value.equals(LEFT) || value.equals(TOP)) {
                corN = 0;
            } else if (value.equals(RIGHT) || value.equals(BOTTOM)) {
                corN = 2;
            }
            specElm.addProperty(x.setting, (Number)corN);
        }
        String validated = new JsonValidator().validateElement(this.elm.getAsJsonObject());
        if (validated == null) {
            ArrayList<JsonElement> deepCopyArray = new ArrayList<JsonElement>();
            for (JsonElement elm : ConfigFiles.elementArray) {
                deepCopyArray.add(elm.deepCopy());
            }
            deepCopyArray.remove(this.BEFORE_EDITING);
            if (!((Object)deepCopyArray).toString().toLowerCase().contains("\"name\":\"" + this.elm.get("name").getAsString().toLowerCase() + "\",")) {
                String old_file_name = this.BEFORE_EDITING.getAsJsonObject().get("name").getAsString();
                if (!old_file_name.equals(this.elm.getAsJsonObject().get("name").getAsString())) {
                    ((ConfigScreen)this.PARENT).addDeletedFile(old_file_name);
                }
                ConfigFiles.elementArray.set(ConfigFiles.elementArray.indexOf(this.BEFORE_EDITING.getAsJsonObject()), (JsonElement)this.elm);
                this.method_25419();
            } else {
                new Tools().sendToast("\u00a7cInvalid!", "\u00a7fThe name must be unique!");
            }
        } else {
            new Tools().sendToast("\u00a7cInvalid!", "\u00a7f" + validated);
        }
    }

    private void openDocumentation() {
        try {
            class_156.method_668().method_670("https://adaptivehud.gitbook.io/");
            AdaptiveHUD.LOGGER.info("Opening AdaptiveHUD documentation in browser... (https://adaptivehud.gitbook.io/)");
        }
        catch (Exception e) {
            AdaptiveHUD.LOGGER.error("Failed to open AdaptiveHUD documentation! Link: https://adaptivehud.gitbook.io/");
            AdaptiveHUD.LOGGER.error(String.valueOf(e));
        }
    }
}

