/*
 * Decompiled with CFR 0.152.
 */
package ahud.adaptivehud.screens.movescreen;

import ahud.adaptivehud.AdaptiveHUD;
import ahud.adaptivehud.ConfigFiles;
import ahud.adaptivehud.Tools;
import ahud.adaptivehud.renderhud.CoordCalculators;
import ahud.adaptivehud.renderhud.RenderHUD;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class MoveScreen
extends class_437 {
    private final class_437 parent;
    private final List<Object[]> posList;
    private double offsetX;
    private double offsetY;
    private int height;
    private int width;
    private Object[] dragInf;
    private JsonObject dragged;
    private final ArrayList<Integer> snapPointsX;
    private final ArrayList<Integer> snapPointsY;
    private boolean shiftPressed = false;
    private double snapX = 0.0;
    private double snapY = 0.0;
    private int anchorX = 0;
    private int anchorY = 0;
    private int alignX = 0;
    private int alignY = 0;
    private boolean autoSave;
    private final int anchorLineColor = new Tools().parseColor(ConfigFiles.configFile.getAsJsonObject().get("anchor_point_lines_color").getAsString());
    private final int snappingLineColor = new Tools().parseColor(ConfigFiles.configFile.getAsJsonObject().get("snapping_lines_color").getAsString());

    public MoveScreen(class_437 parent, boolean autoSave) {
        super(class_2561.method_30163((String)"AdaptiveHUD"));
        this.parent = parent;
        this.posList = new RenderHUD(true).generatePositions();
        this.snapPointsX = new ArrayList();
        this.snapPointsY = new ArrayList();
        this.autoSave = autoSave;
        AdaptiveHUD.renderElements = false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        new RenderHUD(false).renderCustomHud(context);
        if (this.dragged != null) {
            int xPos = new CoordCalculators().getActualCords(this.dragged, this.dragged.get("posX").getAsInt() + this.alignX, this.field_22787.method_22683().method_4486(), this.width, 0.0f, "X");
            int yPos = new CoordCalculators().getActualCords(this.dragged, this.dragged.get("posY").getAsInt() + this.alignY, this.field_22787.method_22683().method_4502(), this.height, 0.0f, "Y");
            context.method_25294(this.anchorX, this.anchorY, xPos, this.anchorY + 2, this.anchorLineColor);
            context.method_25294(xPos, this.anchorY, xPos + 2, yPos, this.anchorLineColor);
            if (this.snapX != 0.0) {
                context.method_25294((int)this.snapX, 0, (int)this.snapX + 1, this.field_22787.field_1755.field_22790, this.snappingLineColor);
            }
            if (this.snapY != 0.0) {
                context.method_25294(0, (int)this.snapY, this.field_22787.field_1755.field_22789, (int)this.snapY + 1, this.snappingLineColor);
            }
        }
    }

    public void method_25419() {
        AdaptiveHUD.renderElements = true;
        if (this.autoSave) {
            new ConfigFiles().saveElementFiles(ConfigFiles.elementArray, new ArrayList<String>());
        }
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (this.dragged != null) {
            boolean foundX = false;
            boolean foundY = false;
            if (!this.shiftPressed) {
                for (int x : this.snapPointsX) {
                    if (Math.abs(click.comp_4798() - offsetX - (double)x) < 5.0) {
                        this.dragged.addProperty("posX", (Number)new CoordCalculators().getRelativeCords(this.dragged, x, this.field_22787.method_22683().method_4486(), this.width, "X"));
                        this.snapX = x;
                        foundX = true;
                        continue;
                    }
                    if (!(Math.abs(click.comp_4798() - offsetX + (double)this.width - (double)x) < 5.0)) continue;
                    this.dragged.addProperty("posX", (Number)new CoordCalculators().getRelativeCords(this.dragged, x - this.width, this.field_22787.method_22683().method_4486(), this.width, "X"));
                    this.snapX = x;
                    foundX = true;
                }
                for (int y : this.snapPointsY) {
                    if (Math.abs(click.comp_4799() - offsetY - (double)y) < 5.0) {
                        this.dragged.addProperty("posY", (Number)new CoordCalculators().getRelativeCords(this.dragged, y, this.field_22787.method_22683().method_4502(), this.height, "Y"));
                        this.snapY = y;
                        foundY = true;
                        continue;
                    }
                    if (!(Math.abs(click.comp_4799() - offsetY + (double)this.height - (double)y) < 5.0)) continue;
                    this.dragged.addProperty("posY", (Number)new CoordCalculators().getRelativeCords(this.dragged, y - this.height, this.field_22787.method_22683().method_4502(), this.height, "Y"));
                    this.snapY = y;
                    foundY = true;
                }
            }
            if (!foundX) {
                this.snapX = 0.0;
                this.dragged.addProperty("posX", (Number)new CoordCalculators().getRelativeCords(this.dragged, (int)(click.comp_4799() - offsetX), this.field_22787.method_22683().method_4486(), this.width, "X"));
            }
            if (!foundY) {
                this.snapY = 0.0;
                this.dragged.addProperty("posY", (Number)new CoordCalculators().getRelativeCords(this.dragged, (int)(click.comp_4799() - offsetY), this.field_22787.method_22683().method_4502(), this.height, "Y"));
            }
        }
        return true;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (click.method_74245() == 0) {
            for (Object[] x : this.posList) {
                if (!(click.comp_4798() >= (double)((Integer)x[1]).intValue()) || !(click.comp_4798() <= (double)((Integer)x[3]).intValue()) || !(click.comp_4799() >= (double)((Integer)x[2]).intValue()) || !(click.comp_4799() <= (double)((Integer)x[4]).intValue())) continue;
                this.dragged = ((JsonElement)x[0]).getAsJsonObject();
                this.offsetX = click.comp_4798() - (double)((Integer)x[1]).intValue();
                this.offsetY = click.comp_4799() - (double)((Integer)x[2]).intValue();
                this.height = (Integer)x[4] - (Integer)x[2];
                this.width = (Integer)x[3] - (Integer)x[1];
                this.dragInf = x;
                this.snapPointsX.clear();
                this.snapPointsX.add(0);
                this.snapPointsX.add(this.field_22787.field_1755.field_22789);
                this.snapPointsY.clear();
                this.snapPointsY.add(0);
                this.snapPointsY.add(this.field_22787.field_1755.field_22790);
                for (Object[] y : this.posList) {
                    if (y == x) continue;
                    this.snapPointsX.add((int)((Integer)y[1]));
                    this.snapPointsX.add((int)((Integer)y[3]));
                    this.snapPointsY.add((int)((Integer)y[2]));
                    this.snapPointsY.add((int)((Integer)y[4]));
                }
                JsonObject align = this.dragged.get("alignment").getAsJsonObject();
                int PanchorX = align.get("anchorPointX").getAsInt();
                this.anchorX = PanchorX == 0 ? 0 : (PanchorX == 1 ? this.field_22787.field_1755.field_22789 / 2 : this.field_22787.field_1755.field_22789);
                int PanchorY = align.get("anchorPointY").getAsInt();
                this.anchorY = PanchorY == 0 ? 0 : (PanchorY == 1 ? this.field_22787.field_1755.field_22790 / 2 - 1 : this.field_22787.field_1755.field_22790 - 2);
                int PalignX = align.get("textAlignX").getAsInt();
                this.alignX = PalignX == 0 ? 0 : (PalignX == 1 ? this.width / 2 : this.width);
                int PalignY = align.get("textAlignY").getAsInt();
                if (PalignY == 0) {
                    this.alignY = 0;
                    continue;
                }
                if (PalignY == 1) {
                    this.alignY = this.height / 2;
                    continue;
                }
                this.alignY = this.height;
            }
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0 && this.dragged != null) {
            int actX = new CoordCalculators().getActualCords(this.dragged, this.dragged.get("posX").getAsInt(), this.field_22787.method_22683().method_4486(), this.width, 0.0f, "X");
            int actY = new CoordCalculators().getActualCords(this.dragged, this.dragged.get("posY").getAsInt(), this.field_22787.method_22683().method_4502(), this.height, 0.0f, "Y");
            this.dragInf[1] = actX;
            this.dragInf[2] = actY;
            this.dragInf[3] = actX + this.width;
            this.dragInf[4] = actY + this.height;
            this.dragged = null;
        }
        return super.method_25406(click);
    }

    public boolean method_25404(class_11908 input) {
        if (input.method_74228() == 340) {
            this.shiftPressed = true;
        }
        return super.method_25404(input);
    }

    public boolean method_16803(class_11908 input) {
        if (input.method_74228() == 340) {
            this.shiftPressed = false;
        }
        return super.method_16803(input);
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        for (Object[] x : this.posList) {
            JsonObject elm = (JsonObject)x[0];
            int lengthX = (Integer)x[3] - (Integer)x[1];
            int lengthY = (Integer)x[4] - (Integer)x[2];
            int posX = new CoordCalculators().getActualCords(elm, elm.get("posX").getAsInt(), width, lengthX, 0.0f, "X");
            int posY = new CoordCalculators().getActualCords(elm, elm.get("posY").getAsInt(), height, lengthY, 0.0f, "Y");
            x[1] = posX;
            x[2] = posY;
            x[3] = posX + lengthX;
            x[4] = posY + lengthY;
        }
    }
}

