/*
 * Decompiled with CFR 0.152.
 */
package polandmod.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import polandmod.potion.HighGravityMobEffect;
import polandmod.potion.LoveMobEffect;
import polandmod.potion.LowGravityMobEffect;
import polandmod.potion.UnreachMobEffect;
import polandmod.potion.VulnerabilityMobEffect;
import polandmod.procedures.LowGravityEffectExpiresProcedure;

@EventBusSubscriber
public class PolandmodModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"polandmod");
    public static final DeferredHolder<MobEffect, MobEffect> LOVE = REGISTRY.register("love", () -> new LoveMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> UNREACH = REGISTRY.register("unreach", () -> new UnreachMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> VULNERABILITY = REGISTRY.register("vulnerability", () -> new VulnerabilityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> HIGH_GRAVITY = REGISTRY.register("high_gravity", () -> new HighGravityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> LOW_GRAVITY = REGISTRY.register("low_gravity", () -> new LowGravityMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            PolandmodModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            PolandmodModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(HIGH_GRAVITY)) {
            LowGravityEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(LOW_GRAVITY)) {
            LowGravityEffectExpiresProcedure.execute(entity);
        }
    }
}

