/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.ScalableOffset;
import org.checkerframework.dataflow.qual.Pure;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface Offset
permits FixedOffset, ScalableOffset {
    public static final FixedOffset ZERO = new FixedOffset(0, 0);
    public static final int ALIGN_DEFAULT_OVERWORLD = 3;

    public static FixedOffset fixed(int x, int z) {
        return new FixedOffset(x, z);
    }

    public static ScalableOffset scalable(int x, int z) {
        return new ScalableOffset(x, z);
    }

    public static ScalableOffset align(int x, int z) {
        return Offset.align(x, z, 3);
    }

    public static ScalableOffset align(int x, int z, int toChunksPower) {
        return new ScalableOffset(Offset.alignComponent(x, toChunksPower), Offset.alignComponent(z, toChunksPower));
    }

    public static ScalableOffset random(int bound) {
        return Offset.random(bound, 3);
    }

    public static ScalableOffset random(int bound, int alignToChunksPower) {
        return new ScalableOffset(Offset.alignComponent(ScalableOffset.RANDOM.nextInt(bound), alignToChunksPower), Offset.alignComponent(ScalableOffset.RANDOM.nextInt(bound), alignToChunksPower));
    }

    public static int alignComponent(int component, int alignToChunksPower) {
        return Math.round((float)component / (float)(1 << alignToChunksPower + 4)) * (1 << alignToChunksPower + 4);
    }

    @Pure
    public Offset negate();

    public boolean isZero();
}

