/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.provider.OffsetProviderConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class OffsetProviderClassRegistry {
    private final Map<String, RegisteredProviderClass> registeredProviders = new HashMap<String, RegisteredProviderClass>();

    public void registerProviderClass(String className, boolean isCore, Function<OffsetProviderConfig, OffsetProvider> deserializeFunction) {
        if (this.registeredProviders.containsKey(className)) {
            throw new IllegalArgumentException("Attempted to re-register Offset provider class: " + className);
        }
        this.registeredProviders.put(className, new RegisteredProviderClass(className, isCore, deserializeFunction));
    }

    public @Nullable RegisteredProviderClass getRegisteredProviderClass(String className) {
        return this.registeredProviders.get(className);
    }

    public record RegisteredProviderClass(String className, boolean isCore, Function<OffsetProviderConfig, OffsetProvider> deserializeFunction) {
    }
}

