/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.command;

import com.jtprince.coordinateoffset.ScalableOffset;
import com.jtprince.coordinateoffset.adapter.OffsetPlayer;
import com.jtprince.coordinateoffset.command.OffsetCommand;
import com.jtprince.coordinateoffset.command.OffsetCommandSender;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class OffsetSetCommand
implements OffsetCommand {
    private final OffsetCommandSender commandSender;
    private final List<OffsetPlayer> targets;
    private final ScalableOffset offset;
    private @Nullable OffsetProvider notPersistentForProvider = null;
    private final Set<OffsetPlayer> notPersistentInProviderTargets = new HashSet<OffsetPlayer>();
    private final Map<OffsetPlayer, Double> scalingForTargets = new HashMap<OffsetPlayer, Double>();

    public OffsetSetCommand(OffsetCommandSender commandSender, List<? extends OffsetPlayer> targets, ScalableOffset offset) {
        this.commandSender = commandSender;
        this.targets = List.copyOf(targets);
        this.offset = offset;
    }

    @Override
    public OffsetCommandSender getCommandSender() {
        return this.commandSender;
    }

    public List<OffsetPlayer> getTargets() {
        return this.targets;
    }

    public ScalableOffset getOffset() {
        return this.offset;
    }

    public void warnOffsetIsNotPersistentInProvider(OffsetProvider provider, OffsetPlayer target) {
        this.notPersistentForProvider = provider;
        this.notPersistentInProviderTargets.add(target);
    }

    public @Nullable OffsetProvider getOffsetIsNotPersistentForProvider(OffsetPlayer target) {
        if (this.notPersistentInProviderTargets.contains(target)) {
            return this.notPersistentForProvider;
        }
        return null;
    }

    public void warnScaling(OffsetPlayer target, double scalingFactor) {
        this.scalingForTargets.put(target, scalingFactor);
    }

    public @Nullable Double getWarnScaling(OffsetPlayer target) {
        return this.scalingForTargets.get(target);
    }
}

