/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.config;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.config.CoordinateOffsetProviderConfig;
import com.jtprince.coordinateoffset.config.OffsetProviderOverrideConfig;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.Configuration;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.UUID;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@Configuration
public class OffsetProviderOverrideConfigImpl
implements OffsetProviderOverrideConfig {
    private @Nullable String provider;
    private @Nullable String world;
    private @Nullable String permission;
    private @Nullable String player;
    @Deprecated
    private @Nullable UUID playerUuid;

    OffsetProviderOverrideConfigImpl() {
    }

    public OffsetProviderOverrideConfigImpl(String provider, @Nullable String world, @Nullable String permission, @Nullable String player) {
        this.provider = provider;
        this.world = world;
        this.permission = permission;
        this.player = player;
    }

    @Override
    public OffsetProvider getOffsetProvider() {
        CoordinateOffsetProviderConfig providers = CoordinateOffsetCore.get().getProviderConfig();
        return Objects.requireNonNull(providers.getAllOffsetProviderConfigs().get(Objects.requireNonNull(this.provider)));
    }

    @Override
    public @Nullable String getWorld() {
        return this.world;
    }

    @Override
    public @Nullable String getPermission() {
        return this.permission;
    }

    @Override
    public @Nullable String getPlayer() {
        return this.player;
    }

    public boolean validate(SequencedMap<String, OffsetProvider> allProviders, boolean logWarning) {
        if (this.playerUuid != null) {
            if (this.player == null) {
                this.player = this.playerUuid.toString();
            }
            this.playerUuid = null;
        }
        StringBuilder b = new StringBuilder();
        if (this.provider != null) {
            b.append(" provider=").append(this.provider);
        }
        if (this.world != null) {
            b.append(" world=").append(this.world);
        }
        if (this.permission != null) {
            b.append(" permission=").append(this.permission);
        }
        if (this.player != null) {
            b.append(" player=").append(this.player);
        }
        if (this.provider == null) {
            if (logWarning) {
                CoordinateOffsetCore.get().getLogger().warning("Ignoring an offset provider override with no provider set:" + String.valueOf(b));
            }
            return false;
        }
        if (!allProviders.containsKey(this.provider)) {
            if (logWarning) {
                CoordinateOffsetCore.get().getLogger().warning("Ignoring an offset provider override with unknown provider:" + String.valueOf(b));
            }
            return false;
        }
        return true;
    }
}

