/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.lib.de.exlll.configlib;

import com.jtprince.coordinateoffset.lib.de.exlll.configlib.YamlConfigurationProperties;
import com.jtprince.coordinateoffset.lib.de.exlll.configlib.YamlConfigurationStore;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.Consumer;

public final class YamlConfigurations {
    private YamlConfigurations() {
    }

    public static <T> T load(Path configurationFile, Class<T> configurationType) {
        YamlConfigurationProperties properties = YamlConfigurationProperties.newBuilder().build();
        return YamlConfigurations.load(configurationFile, configurationType, properties);
    }

    public static <T> T load(Path configurationFile, Class<T> configurationType, Consumer<YamlConfigurationProperties.Builder<?>> propertiesConfigurer) {
        YamlConfigurationProperties.Builder<?> builder = YamlConfigurationProperties.newBuilder();
        propertiesConfigurer.accept(builder);
        return YamlConfigurations.load(configurationFile, configurationType, builder.build());
    }

    public static <T> T load(Path configurationFile, Class<T> configurationType, YamlConfigurationProperties properties) {
        YamlConfigurationStore<T> store = new YamlConfigurationStore<T>(configurationType, properties);
        return store.load(configurationFile);
    }

    public static <T> T read(InputStream inputStream, Class<T> configurationType) {
        YamlConfigurationProperties properties = YamlConfigurationProperties.newBuilder().build();
        return YamlConfigurations.read(inputStream, configurationType, properties);
    }

    public static <T> T read(InputStream inputStream, Class<T> configurationType, Consumer<YamlConfigurationProperties.Builder<?>> propertiesConfigurer) {
        YamlConfigurationProperties.Builder<?> builder = YamlConfigurationProperties.newBuilder();
        propertiesConfigurer.accept(builder);
        return YamlConfigurations.read(inputStream, configurationType, builder.build());
    }

    public static <T> T read(InputStream inputStream, Class<T> configurationType, YamlConfigurationProperties properties) {
        YamlConfigurationStore<T> store = new YamlConfigurationStore<T>(configurationType, properties);
        return store.read(inputStream);
    }

    public static <T> T update(Path configurationFile, Class<T> configurationType) {
        YamlConfigurationProperties properties = YamlConfigurationProperties.newBuilder().build();
        return YamlConfigurations.update(configurationFile, configurationType, properties);
    }

    public static <T> T update(Path configurationFile, Class<T> configurationType, Consumer<YamlConfigurationProperties.Builder<?>> propertiesConfigurer) {
        YamlConfigurationProperties.Builder<?> builder = YamlConfigurationProperties.newBuilder();
        propertiesConfigurer.accept(builder);
        return YamlConfigurations.update(configurationFile, configurationType, builder.build());
    }

    public static <T> T update(Path configurationFile, Class<T> configurationType, YamlConfigurationProperties properties) {
        YamlConfigurationStore<T> store = new YamlConfigurationStore<T>(configurationType, properties);
        return store.update(configurationFile);
    }

    public static <T> void save(Path configurationFile, Class<T> configurationType, T configuration) {
        YamlConfigurationProperties properties = YamlConfigurationProperties.newBuilder().build();
        YamlConfigurations.save(configurationFile, configurationType, configuration, properties);
    }

    public static <T> void save(Path configurationFile, Class<T> configurationType, T configuration, Consumer<YamlConfigurationProperties.Builder<?>> propertiesConfigurer) {
        YamlConfigurationProperties.Builder<?> builder = YamlConfigurationProperties.newBuilder();
        propertiesConfigurer.accept(builder);
        YamlConfigurations.save(configurationFile, configurationType, configuration, builder.build());
    }

    public static <T> void save(Path configurationFile, Class<T> configurationType, T configuration, YamlConfigurationProperties properties) {
        YamlConfigurationStore<T> store = new YamlConfigurationStore<T>(configurationType, properties);
        store.save(configuration, configurationFile);
    }

    public static <T> void write(OutputStream outputStream, Class<T> configurationType, T configuration) {
        YamlConfigurationProperties properties = YamlConfigurationProperties.newBuilder().build();
        YamlConfigurations.write(outputStream, configurationType, configuration, properties);
    }

    public static <T> void write(OutputStream outputStream, Class<T> configurationType, T configuration, Consumer<YamlConfigurationProperties.Builder<?>> propertiesConfigurer) {
        YamlConfigurationProperties.Builder<?> builder = YamlConfigurationProperties.newBuilder();
        propertiesConfigurer.accept(builder);
        YamlConfigurations.write(outputStream, configurationType, configuration, builder.build());
    }

    public static <T> void write(OutputStream outputStream, Class<T> configurationType, T configuration, YamlConfigurationProperties properties) {
        YamlConfigurationStore<T> store = new YamlConfigurationStore<T>(configurationType, properties);
        store.write(configuration, outputStream);
    }
}

