/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.CoordinateOffsetPermission;
import com.jtprince.coordinateoffset.paper.BukkitEventListener;
import com.jtprince.coordinateoffset.paper.MetricsWrapper;
import com.jtprince.coordinateoffset.paper.PacketEventSequencer;
import com.jtprince.coordinateoffset.paper.PacketOffsetAdapter;
import com.jtprince.coordinateoffset.paper.PaperOffsetCommand;
import com.jtprince.coordinateoffset.paper.WorldBorderObfuscator;
import com.jtprince.coordinateoffset.paper.adapter.PaperAdapter;
import com.jtprince.coordinateoffset.paper.lib.org.geysermc.hurricane.CollisionFix;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CoordinateOffsetPaperPlugin
extends JavaPlugin {
    private static @Nullable CoordinateOffsetPaperPlugin instance;
    private @Nullable PaperAdapter adapter;
    private @Nullable CoordinateOffsetCore core;
    private @Nullable WorldBorderObfuscator worldBorderObfuscator;
    private @Nullable PacketOffsetAdapter packetOffsetAdapter;
    private @Nullable CollisionFix collisionFix;

    public void onEnable() {
        block5: {
            instance = this;
            this.adapter = new PaperAdapter(this);
            this.core = CoordinateOffsetCore.bootstrap(this.adapter);
            this.worldBorderObfuscator = new WorldBorderObfuscator(this);
            new BukkitEventListener(this, this.core, this.worldBorderObfuscator).registerListeners();
            new PaperOffsetCommand(this, this.core).registerCommands();
            this.packetOffsetAdapter = new PacketOffsetAdapter(this);
            this.packetOffsetAdapter.registerAdapters();
            if (this.core.isDebugEnabled()) {
                new PacketEventSequencer(this).install();
            }
            for (CoordinateOffsetPermission p : CoordinateOffsetPermission.values()) {
                Bukkit.getPluginManager().addPermission(new Permission(p.node, p.description, PermissionDefault.OP, p.getChildren().stream().collect(Collectors.toMap(p1 -> p1.node, p1 -> true))));
            }
            if (this.core.getConfig().getFixCollisionBamboo() || this.core.getConfig().getFixCollisionDripstone()) {
                try {
                    this.collisionFix = new CollisionFix((Plugin)this, this.core.getConfig().getFixCollisionBamboo(), this.core.getConfig().getFixCollisionDripstone());
                }
                catch (Exception e) {
                    this.getLogger().severe("Failed to enable bamboo/dripstone collision fix: " + e.getMessage());
                    if (!this.core.getConfig().getVerbose()) break block5;
                    e.printStackTrace();
                }
            }
        }
    }

    void onAllPluginsEnabled() {
        CoordinateOffsetCore.get().signalCompletedLoading();
        if (this.isEnabled()) {
            MetricsWrapper.reportMetrics(this);
        }
    }

    public void onDisable() {
        if (this.packetOffsetAdapter != null) {
            this.packetOffsetAdapter.onDisable();
            this.packetOffsetAdapter = null;
        }
    }

    public static @Nullable CoordinateOffsetPaperPlugin getInstance() {
        return instance;
    }

    @Nullable WorldBorderObfuscator getWorldBorderObfuscator() {
        return this.worldBorderObfuscator;
    }
}

