/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.UserDisconnectEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.FixedOffset;
import com.jtprince.coordinateoffset.offsetter.OffsetterRegistry;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetPlayer;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.jtprince.coordinateoffset.util.PartialStacktraceLogger;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.Nullable;

class PacketOffsetAdapter {
    private final CoordinateOffsetCore core = CoordinateOffsetCore.get();
    private final CoordinateOffsetPaperPlugin coPlugin;
    private final Logger logger;
    private final PartialStacktraceLogger partialStacktraceLogger;
    private @Nullable Listener listener;
    private final long stacktraceRateLimitMs = 2500L;

    PacketOffsetAdapter(CoordinateOffsetPaperPlugin plugin) {
        this.coPlugin = plugin;
        this.logger = plugin.getLogger();
        this.partialStacktraceLogger = new PartialStacktraceLogger(this.logger);
        Bukkit.getServer().getScheduler().runTaskTimer((Plugin)this.coPlugin, () -> this.partialStacktraceLogger.flushRateLimits(2500L), 50L, 50L);
    }

    void registerAdapters() {
        this.listener = new Listener();
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.listener);
    }

    void onDisable() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.listener);
        this.listener = null;
        this.partialStacktraceLogger.flushRateLimits(0L);
    }

    private class Listener
    extends PacketListenerAbstract {
        private static final Set<PacketType.Play.Server> PACKETS_WORLD_BORDER = Set.of(PacketType.Play.Server.INITIALIZE_WORLD_BORDER, PacketType.Play.Server.WORLD_BORDER_CENTER, PacketType.Play.Server.WORLD_BORDER_LERP_SIZE, PacketType.Play.Server.WORLD_BORDER_SIZE, PacketType.Play.Server.WORLD_BORDER_WARNING_DELAY, PacketType.Play.Server.WORLD_BORDER_WARNING_REACH);

        Listener() {
            super(PacketListenerPriority.HIGH);
        }

        public void onPacketSend(PacketSendEvent event) {
            if (event.getPlayer() == null || !(event.getPacketType() instanceof PacketType.Play.Server)) {
                return;
            }
            try {
                FixedOffset offset;
                if (event.getPacketType() == PacketType.Play.Server.PLAYER_POSITION_AND_LOOK) {
                    PacketOffsetAdapter.this.core.getOffsetHolder().swapInNextOffset(new PaperOffsetPlayer((Player)event.getPlayer()));
                }
                if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME) {
                    try {
                        offset = PacketOffsetAdapter.this.core.getOffsetHolder().waitForJoiningOffset(event.getUser().getUUID(), 5000);
                    }
                    catch (TimeoutException e) {
                        PacketOffsetAdapter.this.logger.severe("Timed out waiting for an offset to generate for " + event.getUser().getName() + ".");
                        PacketOffsetAdapter.this.logger.severe("This is a bug in CoordinateOffset. Please report it.");
                        e.printStackTrace();
                        event.setCancelled(true);
                        return;
                    }
                } else {
                    offset = event.getPacketType() == PacketType.Play.Server.RESPAWN ? PacketOffsetAdapter.this.core.getOffsetHolder().getNextOffset(new PaperOffsetPlayer((Player)event.getPlayer())).offset() : PacketOffsetAdapter.this.core.getOffsetHolder().getOffset(new PaperOffsetPlayer((Player)event.getPlayer())).offset();
                }
                if (offset.isZero()) {
                    return;
                }
                if (PacketOffsetAdapter.this.core.getConfig().getObfuscateDebugPropertySubscriptions() && event.getPacketType().getName().startsWith("DEBUG")) {
                    event.setCancelled(true);
                    return;
                }
                if (PACKETS_WORLD_BORDER.contains(event.getPacketType()) && PacketOffsetAdapter.this.coPlugin.getWorldBorderObfuscator() != null) {
                    PacketOffsetAdapter.this.coPlugin.getWorldBorderObfuscator().translate(event, (Player)event.getPlayer());
                    return;
                }
                OffsetterRegistry.attemptToOffset(event, offset);
            }
            catch (Exception e) {
                boolean bl = PacketOffsetAdapter.this.partialStacktraceLogger.logStacktraceRateLimited(PacketOffsetAdapter.this.logger, "Failed to apply offset for outgoing packet " + event.getPacketType().getName() + " to " + event.getUser().getName(), e, 2500L, event.getUser().getName());
            }
        }

        public void onPacketReceive(PacketReceiveEvent event) {
            if (event.getPlayer() == null || !(event.getPacketType() instanceof PacketType.Play.Client)) {
                return;
            }
            try {
                FixedOffset offset = PacketOffsetAdapter.this.core.getOffsetHolder().getOffset(new PaperOffsetPlayer((Player)event.getPlayer())).offset();
                if (offset.isZero()) {
                    return;
                }
                OffsetterRegistry.attemptToUnOffset(event, offset);
            }
            catch (Exception e) {
                boolean bl = PacketOffsetAdapter.this.partialStacktraceLogger.logStacktraceRateLimited(PacketOffsetAdapter.this.logger, "Failed to reverse offset for incoming packet " + event.getPacketType().getName() + " from " + event.getUser().getName(), e, 2500L, event.getUser().getName());
            }
        }

        public void onUserDisconnect(UserDisconnectEvent event) {
            UUID playerUuid = event.getUser().getUUID();
            if (playerUuid == null) {
                return;
            }
            Player onlinePlayer = Bukkit.getPlayer((UUID)playerUuid);
            if (onlinePlayer != null && PacketEvents.getAPI().getPlayerManager().getUser((Object)onlinePlayer) != event.getUser()) {
                return;
            }
            PacketOffsetAdapter.this.core.getOffsetHolder().remove(playerUuid);
            for (OffsetProvider provider : PacketOffsetAdapter.this.core.getProviderConfig().getAllOffsetProviderConfigs().values()) {
                try {
                    provider.onPlayerDisconnect(playerUuid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (PacketOffsetAdapter.this.coPlugin.getWorldBorderObfuscator() != null) {
                PacketOffsetAdapter.this.coPlugin.getWorldBorderObfuscator().onPlayerDisconnect(playerUuid);
            }
        }
    }
}

