/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.CoordinateOffsetPermission;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.ScalableOffset;
import com.jtprince.coordinateoffset.command.OffsetCommandExecutor;
import com.jtprince.coordinateoffset.command.OffsetCommandSender;
import com.jtprince.coordinateoffset.command.OffsetQueryCommand;
import com.jtprince.coordinateoffset.command.OffsetRegenerateCommand;
import com.jtprince.coordinateoffset.command.OffsetReloadCommand;
import com.jtprince.coordinateoffset.command.OffsetSetCommand;
import com.jtprince.coordinateoffset.paper.CoordinateOffsetPaperPlugin;
import com.jtprince.coordinateoffset.paper.adapter.PaperOffsetPlayer;
import com.jtprince.coordinateoffset.provider.OffsetProvider;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PaperOffsetCommand {
    private static final Set<CoordinateOffsetPermission> ROOT_COMMAND_PERMS = Set.of(CoordinateOffsetPermission.QUERY_SELF, CoordinateOffsetPermission.QUERY_OTHERS, CoordinateOffsetPermission.RELOAD, CoordinateOffsetPermission.REGENERATE_SELF, CoordinateOffsetPermission.REGENERATE_OTHERS, CoordinateOffsetPermission.SET_SELF, CoordinateOffsetPermission.SET_OTHERS);
    private final CoordinateOffsetPaperPlugin plugin;
    private final CoordinateOffsetCore core;

    public PaperOffsetCommand(CoordinateOffsetPaperPlugin plugin, CoordinateOffsetCore core) {
        this.plugin = plugin;
        this.core = core;
    }

    public void registerCommands() {
        LiteralArgumentBuilder root = Commands.literal((String)"offset");
        ((LiteralArgumentBuilder)root.requires(sender -> this.pluginEnabled() && ROOT_COMMAND_PERMS.stream().anyMatch(p -> sender.getSender().hasPermission(p.node)))).executes(this::querySelf);
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").requires(sender -> this.pluginEnabled() && (sender.getSender().hasPermission(CoordinateOffsetPermission.QUERY_SELF.node) || sender.getSender().hasPermission(CoordinateOffsetPermission.QUERY_OTHERS.node)))).executes(this::querySelf)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).requires(sender -> this.pluginEnabled() && sender.getSender().hasPermission(CoordinateOffsetPermission.QUERY_OTHERS.node))).executes(this::queryOther)));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(sender -> this.pluginEnabled() && sender.getSender().hasPermission(CoordinateOffsetPermission.RELOAD.node))).executes(this::reload));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"regenerate").requires(sender -> this.pluginEnabled() && (sender.getSender().hasPermission(CoordinateOffsetPermission.REGENERATE_SELF.node) || sender.getSender().hasPermission(CoordinateOffsetPermission.REGENERATE_OTHERS.node)))).executes(this::regenerate)).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)ArgumentTypes.players()).requires(sender -> this.pluginEnabled() && sender.getSender().hasPermission(CoordinateOffsetPermission.REGENERATE_OTHERS.node))).executes(this::regenerate)));
        this.plugin.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> ((Commands)commands.registrar()).register(root.build()));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(sender -> this.pluginEnabled() && (sender.getSender().hasPermission(CoordinateOffsetPermission.SET_SELF.node) || sender.getSender().hasPermission(CoordinateOffsetPermission.SET_OTHERS.node)))).then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer((int)(-OffsetProvider.OFFSET_MAX), (int)OffsetProvider.OFFSET_MAX)).then(((RequiredArgumentBuilder)Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer((int)(-OffsetProvider.OFFSET_MAX), (int)OffsetProvider.OFFSET_MAX)).executes(this::set)).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)ArgumentTypes.players()).requires(sender -> this.pluginEnabled() && sender.getSender().hasPermission(CoordinateOffsetPermission.SET_OTHERS.node))).executes(this::set)))));
        this.plugin.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> ((Commands)commands.registrar()).register(root.build()));
    }

    private int reload(CommandContext<CommandSourceStack> context) {
        return PaperOffsetCommand.toResult(this.core.getCommandExecutor().execute(new OffsetReloadCommand(PaperOffsetCommand.toSender(((CommandSourceStack)context.getSource()).getSender()))));
    }

    private int querySelf(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).getSender().hasPermission(CoordinateOffsetPermission.QUERY_SELF.node)) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(Bukkit.permissionMessage());
            return 0;
        }
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(commandSender instanceof Player)) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)Component.text((String)"You must be a player to query your own offset."));
            return 0;
        }
        Player player = (Player)commandSender;
        boolean isVerbose = ((CommandSourceStack)context.getSource()).getSender().hasPermission(CoordinateOffsetPermission.QUERY_VERBOSE.node);
        OffsetQueryCommand offsetQueryCommand = new OffsetQueryCommand(PaperOffsetCommand.toSender(((CommandSourceStack)context.getSource()).getSender()), new PaperOffsetPlayer(player), isVerbose);
        return PaperOffsetCommand.toResult(this.core.getCommandExecutor().execute(offsetQueryCommand));
    }

    private int queryOther(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class);
        Player target = (Player)((List)targetResolver.resolve((CommandSourceStack)context.getSource())).getFirst();
        if (target == null) {
            return 0;
        }
        boolean isVerbose = ((CommandSourceStack)context.getSource()).getSender().hasPermission(CoordinateOffsetPermission.QUERY_VERBOSE.node);
        OffsetQueryCommand offsetQueryCommand = new OffsetQueryCommand(PaperOffsetCommand.toSender(((CommandSourceStack)context.getSource()).getSender()), new PaperOffsetPlayer(target), isVerbose);
        return PaperOffsetCommand.toResult(this.core.getCommandExecutor().execute(offsetQueryCommand));
    }

    private int regenerate(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List<Player> targets;
        try {
            PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("players", PlayerSelectorArgumentResolver.class);
            targets = (List<Player>)targetResolver.resolve((CommandSourceStack)context.getSource());
        }
        catch (IllegalArgumentException e) {
            CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
            if (!(commandSender instanceof Player)) {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)Component.text((String)"You must be a player to regenerate your own offset."));
                return 0;
            }
            Player player = (Player)commandSender;
            targets = List.of(player);
        }
        if (targets.stream().anyMatch(target -> !target.equals((Object)((CommandSourceStack)context.getSource()).getSender()) && !((CommandSourceStack)context.getSource()).getSender().hasPermission(CoordinateOffsetPermission.REGENERATE_OTHERS.node))) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(Bukkit.permissionMessage());
            return 0;
        }
        OffsetRegenerateCommand offsetRegenerateCommand = new OffsetRegenerateCommand(PaperOffsetCommand.toSender(((CommandSourceStack)context.getSource()).getSender()), targets.stream().map(PaperOffsetPlayer::new).toList());
        return PaperOffsetCommand.toResult(this.core.getCommandExecutor().execute(offsetRegenerateCommand));
    }

    private int set(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List<Player> targets;
        try {
            PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("players", PlayerSelectorArgumentResolver.class);
            targets = (List<Player>)targetResolver.resolve((CommandSourceStack)context.getSource());
        }
        catch (IllegalArgumentException e) {
            CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
            if (!(commandSender instanceof Player)) {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage((Component)Component.text((String)"You must be a player to set your own offset."));
                return 0;
            }
            Player player = (Player)commandSender;
            targets = List.of(player);
        }
        if (targets.stream().anyMatch(target -> !target.equals((Object)((CommandSourceStack)context.getSource()).getSender()) && !((CommandSourceStack)context.getSource()).getSender().hasPermission(CoordinateOffsetPermission.SET_OTHERS.node))) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(Bukkit.permissionMessage());
            return 0;
        }
        int x = IntegerArgumentType.getInteger(context, (String)"x");
        int z = IntegerArgumentType.getInteger(context, (String)"z");
        if (x % 16 != 0 || z % 16 != 0) {
            this.core.getMessages().set.warningNotMultipleOf16.send((Audience)((CommandSourceStack)context.getSource()).getSender(), new TagResolver[0]);
        }
        ScalableOffset offset = Offset.scalable(x, z);
        OffsetSetCommand offsetSetCommand = new OffsetSetCommand(PaperOffsetCommand.toSender(((CommandSourceStack)context.getSource()).getSender()), targets.stream().map(PaperOffsetPlayer::new).toList(), offset);
        return PaperOffsetCommand.toResult(this.core.getCommandExecutor().execute(offsetSetCommand));
    }

    private static OffsetCommandSender toSender(CommandSender sender) {
        return new OffsetCommandSender((Audience)sender, sender.getName(), sender instanceof Player ? new PaperOffsetPlayer((Player)sender) : null);
    }

    private static int toResult(OffsetCommandExecutor.Result result) {
        return switch (result) {
            default -> throw new MatchException(null, null);
            case OffsetCommandExecutor.Result.SUCCESS -> 1;
            case OffsetCommandExecutor.Result.FAIL -> 0;
        };
    }

    private boolean pluginEnabled() {
        return this.plugin != null && this.plugin.isEnabled();
    }
}

