/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.paper.adapter;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import com.jtprince.coordinateoffset.adapter.OffsetWorld;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperWorld
implements OffsetWorld {
    UUID uuid;

    public PaperWorld(UUID worldUuid) {
        this.uuid = worldUuid;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.getPlatformPlayerObject().getName();
    }

    @Override
    public String getKey() {
        return this.getPlatformPlayerObject().getKey().asString();
    }

    @Override
    public Double getCoordinateScale() {
        World world = this.getPlatformPlayerObject();
        SequencedMap<String, Double> overrides = CoordinateOffsetCore.get().getConfig().getWorldCoordinateScaleOverrides();
        if (overrides.containsKey(world.getUID().toString())) {
            return (Double)overrides.get(world.getUID().toString());
        }
        if (overrides.containsKey(world.getName())) {
            return (Double)overrides.get(world.getName());
        }
        if (overrides.containsKey(world.getKey().asString())) {
            return (Double)overrides.get(world.getKey().asString());
        }
        return this.getPlatformPlayerObject().getCoordinateScale();
    }

    public World getPlatformPlayerObject() {
        return Objects.requireNonNull(Bukkit.getWorld((UUID)this.uuid));
    }

    public String toString() {
        return this.getPlatformPlayerObject().toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PaperWorld)) return false;
        PaperWorld w = (PaperWorld)obj;
        if (!this.uuid.equals(w.uuid)) return false;
        return true;
    }
}

