/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider.util;

import com.jtprince.coordinateoffset.CoordinateOffsetCore;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record RegenerateConfig(Boolean regenerateOnJoin, Boolean regenerateOnDeath, Boolean regenerateOnWorldChange, Boolean regenerateOnTeleport, @Nullable Double minimumTeleportDistance, @Nullable String persistenceKeyOverride) {
    public static final double DEFAULT_MINIMUM_TELEPORT_DISTANCE = 256.0;
    public static final String LEGACY_DEFAULT_PERSISTENCE_KEY = "default";

    public boolean isRegenOnJoin() {
        return this.regenerateOnJoin;
    }

    public boolean isRegenOnDeath() {
        return this.regenerateOnDeath;
    }

    public boolean isRegenOnWorldChange() {
        return this.regenerateOnWorldChange;
    }

    public boolean isRegenOnDistantTeleport(double distance) {
        return this.regenerateOnTeleport != false && distance > Objects.requireNonNullElse(this.minimumTeleportDistance, 256.0);
    }

    public void serializeTo(SequencedMap<String, Object> map) {
        map.put("regenerateOnJoin", this.regenerateOnJoin);
        map.put("regenerateOnDeath", this.regenerateOnDeath);
        map.put("regenerateOnWorldChange", this.regenerateOnWorldChange);
        map.put("regenerateOnTeleport", this.regenerateOnTeleport);
        if (this.minimumTeleportDistance != null) {
            map.put("minimumTeleportDistance", this.minimumTeleportDistance);
        }
        if (this.persistenceKeyOverride != null) {
            map.put("persistenceKeyOverride", this.persistenceKeyOverride);
        }
    }

    public static RegenerateConfig deserialize(String providerName, Map<String, ?> providerConfig) throws IllegalArgumentException {
        Object b;
        Object obj;
        Object b2;
        Object b3;
        boolean regenerateOnJoin;
        if (providerConfig.get("regenerateOnJoin") != null) {
            var4_2 = providerConfig.get("regenerateOnJoin");
            if (!(var4_2 instanceof Boolean)) {
                throw new IllegalArgumentException("regenerateOnJoin must be a boolean");
            }
            Boolean b4 = (Boolean)var4_2;
            regenerateOnJoin = b4;
        } else if (providerConfig.get("persistent") != null) {
            var4_2 = providerConfig.get("persistent");
            if (!(var4_2 instanceof Boolean)) {
                throw new IllegalArgumentException("persistent must be a boolean");
            }
            Boolean persistent = (Boolean)var4_2;
            CoordinateOffsetCore.get().getLogger().info("Provider \"" + providerName + "\": Migrating legacy key persistent to regenerateOnJoin");
            regenerateOnJoin = persistent == false;
        } else {
            regenerateOnJoin = CoordinateOffsetCore.get().getConfig().getConfigVersion() != null && CoordinateOffsetCore.get().getConfig().getConfigVersion() <= 5;
        }
        String persistenceKeyOverride = null;
        if (providerConfig.containsKey("persistenceKeyOverride")) {
            persistenceKeyOverride = providerConfig.get("persistenceKeyOverride").toString();
        } else if (providerConfig.containsKey("persistenceKey") && !providerConfig.get("persistenceKey").toString().equals(LEGACY_DEFAULT_PERSISTENCE_KEY)) {
            CoordinateOffsetCore.get().getLogger().info("Provider \"" + providerName + "\": Migrating legacy key persistenceKey to persistenceKeyOverride");
            persistenceKeyOverride = providerConfig.get("persistenceKey").toString();
        }
        boolean regenerateOnDeath = false;
        if (providerConfig.get("regenerateOnDeath") != null) {
            Object obj2 = providerConfig.get("regenerateOnDeath");
            if (!(obj2 instanceof Boolean)) {
                throw new IllegalArgumentException("regenerateOnDeath must be a boolean");
            }
            b3 = (Boolean)obj2;
            regenerateOnDeath = (Boolean)b3;
        } else if (providerConfig.get("resetOnDeath") != null && (b3 = providerConfig.get("resetOnDeath")) instanceof Boolean) {
            Boolean b5 = (Boolean)b3;
            regenerateOnDeath = b5;
        }
        boolean regenerateOnWorldChange = false;
        if (providerConfig.get("regenerateOnWorldChange") != null) {
            Object obj3 = providerConfig.get("regenerateOnWorldChange");
            if (!(obj3 instanceof Boolean)) {
                throw new IllegalArgumentException("regenerateOnWorldChange must be a boolean");
            }
            b2 = (Boolean)obj3;
            regenerateOnWorldChange = (Boolean)b2;
        } else if (providerConfig.get("resetOnWorldChange") != null && (b2 = providerConfig.get("resetOnWorldChange")) instanceof Boolean) {
            b3 = (Boolean)b2;
            regenerateOnWorldChange = (Boolean)b3;
        }
        boolean regenerateOnTeleport = false;
        if (providerConfig.get("regenerateOnTeleport") != null) {
            obj = providerConfig.get("regenerateOnTeleport");
            if (!(obj instanceof Boolean)) {
                throw new IllegalArgumentException("regenerateOnTeleport must be a boolean");
            }
            b = (Boolean)obj;
            regenerateOnTeleport = (Boolean)b;
        } else if (providerConfig.get("resetOnDistantTeleport") != null && (b = providerConfig.get("resetOnDistantTeleport")) instanceof Boolean) {
            b2 = (Boolean)b;
            regenerateOnTeleport = (Boolean)b2;
        }
        Double minimumTeleportDistance = null;
        if (providerConfig.get("minimumTeleportDistance") != null) {
            obj = providerConfig.get("minimumTeleportDistance");
            if (!(obj instanceof Number)) {
                throw new IllegalArgumentException("minimumTeleportDistance must be a number");
            }
            Number l = (Number)obj;
            minimumTeleportDistance = l.doubleValue();
        } else if (regenerateOnTeleport) {
            minimumTeleportDistance = 256.0;
        }
        return new RegenerateConfig(regenerateOnJoin, regenerateOnDeath, regenerateOnWorldChange, regenerateOnTeleport, minimumTeleportDistance, persistenceKeyOverride);
    }

    public String getMetricsCharacterString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.regenerateOnJoin != false ? "J" : "x");
        sb.append(this.regenerateOnDeath != false ? "D" : "x");
        sb.append(this.regenerateOnWorldChange != false ? "W" : "x");
        sb.append(this.regenerateOnTeleport != false ? "T" : "x");
        return sb.toString();
    }
}

