/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PartialStacktraceLogger {
    private final Logger logger;
    private final HashMap<RateLimitEntryKey, RateLimitEntry> activeRateLimits = new HashMap();

    public PartialStacktraceLogger(Logger logger) {
        this.logger = logger;
    }

    private String getStackTraceString(String message, Exception e) {
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(e.getStackTrace()));
        ArrayList<StackTraceElement> current = new ArrayList<StackTraceElement>(Arrays.asList(Thread.currentThread().getStackTrace()));
        int popBuffer = 2;
        int popped = 0;
        while (stack.size() > 3 && current.size() > 3 && ((StackTraceElement)stack.get(stack.size() - 2)).equals(current.get(current.size() - 2))) {
            stack.remove(stack.size() - 1);
            current.remove(current.size() - 1);
            ++popped;
        }
        return message + "\nCaused by " + e.getClass().getName() + ": " + e.getMessage() + "\n  " + stack.stream().map(StackTraceElement::toString).collect(Collectors.joining("\n  ")) + "\n (+" + popped + " hidden frames)";
    }

    public void logStacktrace(String message, Exception e) {
        this.logger.severe(this.getStackTraceString(message, e));
    }

    public boolean logStacktraceRateLimited(Logger logger, String message, Exception e, long rateLimitIntervalMs, String aggregateKey) {
        long currentTime = System.currentTimeMillis();
        RateLimitEntryKey key = new RateLimitEntryKey(e.getClass(), aggregateKey);
        RateLimitEntry entry = this.activeRateLimits.get(key);
        boolean print = true;
        if (entry == null) {
            entry = new RateLimitEntry();
            entry.lastLoggedTime = currentTime;
            this.activeRateLimits.put(key, entry);
        } else if (currentTime - entry.lastLoggedTime < rateLimitIntervalMs) {
            print = false;
        }
        if (print) {
            if (entry.numUnloggedOccurrences > 0) {
                logger.severe(entry.numUnloggedOccurrences + " occurrence" + (entry.numUnloggedOccurrences == 1 ? "" : "s") + " of the following exception " + (entry.numUnloggedOccurrences == 1 ? "was" : "were") + " rate limited for " + aggregateKey + " in the last " + (currentTime - entry.lastLoggedTime) + "ms.");
                entry.lastLoggedTime = currentTime;
                entry.numUnloggedOccurrences = 0;
                entry.lastUnloggedStacktrace = null;
                entry.lastUnloggedException = null;
            }
            this.logStacktrace(message, e);
        } else {
            ++entry.numUnloggedOccurrences;
            entry.lastUnloggedStacktrace = this.getStackTraceString(message, e);
            entry.lastUnloggedException = e;
        }
        return print;
    }

    public void flushRateLimits(long minAgeMs) {
        long currentTime = System.currentTimeMillis();
        this.activeRateLimits.keySet().removeIf(key -> {
            boolean flush;
            RateLimitEntry entry = this.activeRateLimits.get(key);
            boolean bl = flush = currentTime - entry.lastLoggedTime >= minAgeMs;
            if (flush && entry.numUnloggedOccurrences > 0) {
                this.logger.severe(entry.numUnloggedOccurrences + " occurrence" + (entry.numUnloggedOccurrences == 1 ? "" : "s") + " of " + entry.lastUnloggedException.getClass().getSimpleName() + " " + (entry.numUnloggedOccurrences == 1 ? "was" : "were") + " rate limited for " + key.aggregateKey + " in the last " + (currentTime - entry.lastLoggedTime) + "ms. Last stacktrace was:");
                this.logger.severe(entry.lastUnloggedStacktrace);
            }
            return flush;
        });
    }

    private record RateLimitEntryKey(Class<? extends Exception> clazz, String aggregateKey) {
    }

    private static class RateLimitEntry {
        long lastLoggedTime;
        int numUnloggedOccurrences = 0;
        @Nullable String lastUnloggedStacktrace;
        @Nullable Exception lastUnloggedException;

        private RateLimitEntry() {
        }
    }
}

