/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.OffsetProviderContext;
import com.jtprince.coordinateoffset.PlayerOffsetsManager;
import com.jtprince.coordinateoffset.WorldBorderObfuscator;
import io.papermc.paper.entity.TeleportFlag;
import java.util.Objects;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

class BukkitEventListener
implements Listener {
    private final CoordinateOffset plugin;
    private final PlayerOffsetsManager players;
    private final WorldBorderObfuscator worldBorderObfuscator;

    BukkitEventListener(CoordinateOffset plugin, PlayerOffsetsManager playerOffsetsManager, WorldBorderObfuscator worldBorderObfuscator) {
        this.plugin = plugin;
        this.players = playerOffsetsManager;
        this.worldBorderObfuscator = worldBorderObfuscator;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onServerLoad(ServerLoadEvent event) {
        this.plugin.onAllPluginsEnabled();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSpawnLocation(PlayerSpawnLocationEvent event) {
        this.plugin.getPlayerManager().setPositionedWorld(event.getPlayer(), event.getSpawnLocation().getWorld());
        OffsetProviderContext context = new OffsetProviderContext(event.getPlayer(), event.getSpawnLocation().getWorld(), event.getSpawnLocation(), OffsetProviderContext.ProvideReason.JOIN, this.plugin);
        this.plugin.getPlayerManager().regenerateOffset(context);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        OffsetProviderContext.ProvideReason reason = OffsetProviderContext.ProvideReason.DEATH_RESPAWN;
        try {
            if (event.getRespawnReason() != PlayerRespawnEvent.RespawnReason.DEATH) {
                reason = OffsetProviderContext.ProvideReason.WORLD_CHANGE;
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            try {
                if (event.getRespawnFlags().contains(PlayerRespawnEvent.RespawnFlag.END_PORTAL)) {
                    reason = OffsetProviderContext.ProvideReason.WORLD_CHANGE;
                }
            }
            catch (NoClassDefFoundError | NoSuchMethodError e2) {
                this.plugin.getLogger().fine("No supported method for determining respawn reason.");
            }
        }
        OffsetProviderContext context = new OffsetProviderContext(event.getPlayer(), Objects.requireNonNull(event.getRespawnLocation().getWorld()), event.getRespawnLocation(), reason, this.plugin);
        this.plugin.getPlayerManager().regenerateOffset(context);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        OffsetProviderContext.ProvideReason reason = null;
        if (event.getFrom().getWorld() != Objects.requireNonNull(event.getTo()).getWorld()) {
            reason = OffsetProviderContext.ProvideReason.WORLD_CHANGE;
        } else if (event.getFrom().distanceSquared(event.getTo()) > (double)this.getMinimumTeleportDistanceSquared(event.getTo().getWorld()) && this.plugin.isUnsafeResetOnTeleportEnabled()) {
            boolean isTeleportDefinitelyRelative = false;
            try {
                Set flags = event.getRelativeTeleportationFlags();
                if (flags.contains(TeleportFlag.Relative.X) || flags.contains(TeleportFlag.Relative.Z)) {
                    isTeleportDefinitelyRelative = true;
                }
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
                // empty catch block
            }
            if (!isTeleportDefinitelyRelative) {
                reason = OffsetProviderContext.ProvideReason.DISTANT_TELEPORT;
            }
        }
        if (reason == null) {
            return;
        }
        OffsetProviderContext context = new OffsetProviderContext(event.getPlayer(), Objects.requireNonNull(event.getTo().getWorld()), event.getTo(), reason, this.plugin);
        this.plugin.getPlayerManager().regenerateOffset(context);
        this.worldBorderObfuscator.tryUpdatePlayerBorders(event.getPlayer(), event.getTo());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        this.worldBorderObfuscator.tryUpdatePlayerBorders(event.getPlayer(), event.getTo());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getOffsetProviderManager().quitPlayer(event.getPlayer());
    }

    private int getMinimumTeleportDistanceSquared(World world) {
        int viewDistance = world.getViewDistance();
        int minimumBlocks = (viewDistance + 1) * 2 * 16;
        if (this.plugin.getConfig().isInt("distantTeleportMinimumDistance")) {
            minimumBlocks = this.plugin.getConfig().getInt("distantTeleportMinimumDistance");
        }
        return minimumBlocks * minimumBlocks;
    }
}

