/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.BukkitEventListener;
import com.jtprince.coordinateoffset.CoordinateOffsetCommands;
import com.jtprince.coordinateoffset.MetricsWrapper;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.OffsetProvider;
import com.jtprince.coordinateoffset.OffsetProviderManager;
import com.jtprince.coordinateoffset.PacketOffsetAdapter;
import com.jtprince.coordinateoffset.PlayerOffsetsManager;
import com.jtprince.coordinateoffset.WorldBorderObfuscator;
import com.jtprince.coordinateoffset.provider.ConstantOffsetProvider;
import com.jtprince.coordinateoffset.provider.RandomOffsetProvider;
import com.jtprince.coordinateoffset.provider.ZeroAtLocationOffsetProvider;
import com.jtprince.lib.com.github.retrooper.packetevents.PacketEvents;
import com.jtprince.lib.io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import com.jtprince.lib.org.geysermc.hurricane.CollisionFix;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CoordinateOffset
extends JavaPlugin {
    private static CoordinateOffset instance;
    private PlayerOffsetsManager playerOffsetsManager;
    private OffsetProviderManager providerManager;
    private WorldBorderObfuscator worldBorderObfuscator;
    @Nullable
    private CollisionFix collisionFix;

    public void onLoad() {
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        block3: {
            instance = this;
            this.saveDefaultConfig();
            this.playerOffsetsManager = new PlayerOffsetsManager(this);
            this.providerManager = new OffsetProviderManager(this);
            this.worldBorderObfuscator = new WorldBorderObfuscator(this);
            Bukkit.getPluginManager().registerEvents((Listener)new BukkitEventListener(this, this.playerOffsetsManager, this.worldBorderObfuscator), (Plugin)this);
            CoordinateOffsetCommands commands = new CoordinateOffsetCommands(this);
            Objects.requireNonNull(this.getCommand("offset")).setExecutor((CommandExecutor)new CoordinateOffsetCommands.OffsetCommand(commands));
            Objects.requireNonNull(this.getCommand("offsetreload")).setExecutor((CommandExecutor)new CoordinateOffsetCommands.OffsetReloadCommand(commands));
            this.providerManager.registerConfigurationFactory("ConstantOffsetProvider", new ConstantOffsetProvider.ConfigFactory());
            this.providerManager.registerConfigurationFactory("RandomOffsetProvider", new RandomOffsetProvider.ConfigFactory());
            this.providerManager.registerConfigurationFactory("ZeroAtLocationOffsetProvider", new ZeroAtLocationOffsetProvider.ConfigFactory());
            new PacketOffsetAdapter(this).registerAdapters();
            boolean collisionFixBambooEnabled = this.getConfig().getBoolean("fixCollision.bamboo", true);
            boolean collisionFixDripstoneEnabled = this.getConfig().getBoolean("fixCollision.dripstone", true);
            if (collisionFixBambooEnabled || collisionFixDripstoneEnabled) {
                try {
                    this.collisionFix = new CollisionFix((Plugin)this, collisionFixBambooEnabled, collisionFixDripstoneEnabled);
                }
                catch (Exception e) {
                    this.getLogger().severe("Failed to enable bamboo/dripstone collision fix: " + e.getMessage());
                    if (!this.isVerboseLoggingEnabled()) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    void onAllPluginsEnabled() {
        this.providerManager.loadProvidersFromConfig(this.getConfig());
        MetricsWrapper.reportMetrics(this);
    }

    public void onDisable() {
    }

    public void reload() {
        this.reloadConfig();
        this.providerManager.loadProvidersFromConfig(this.getConfig());
        this.getLogger().info("Config reloaded.");
    }

    @Nullable
    public static CoordinateOffset getInstance() {
        return instance;
    }

    public boolean isVerboseLoggingEnabled() {
        return this.getConfig().getBoolean("verbose");
    }

    public boolean isDebugEnabled() {
        return this.getConfig().getBoolean("debug.enable");
    }

    boolean isUnsafeResetOnTeleportEnabled() {
        return this.getConfig().getBoolean("allowUnsafeResetOnDistantTeleport");
    }

    @NotNull
    public Offset getOffset(@NotNull Player player) {
        return this.playerOffsetsManager.getOffset(player);
    }

    public void registerCustomProviderClass(@NotNull String className, @NotNull OffsetProvider.ConfigurationFactory<?> providerConfigFactory) {
        this.providerManager.registerConfigurationFactory(className, providerConfigFactory);
    }

    PlayerOffsetsManager getPlayerManager() {
        return this.playerOffsetsManager;
    }

    OffsetProviderManager getOffsetProviderManager() {
        return this.providerManager;
    }

    WorldBorderObfuscator getWorldBorderObfuscator() {
        return this.worldBorderObfuscator;
    }
}

