/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import java.util.Objects;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class CoordinateOffsetCommands {
    private final CoordinateOffset plugin;
    private final ComponentBuilder prefix = new ComponentBuilder("[CoordinateOffset] ").color(ChatColor.AQUA);

    public CoordinateOffsetCommands(CoordinateOffset plugin) {
        this.plugin = plugin;
    }

    private void replyOk(CommandSender to, String message) {
        to.spigot().sendMessage(new ComponentBuilder(this.prefix).append(message).color(ChatColor.GREEN).create());
    }

    private void replyError(CommandSender to, String message) {
        to.spigot().sendMessage(new ComponentBuilder(this.prefix).append(message).color(ChatColor.RED).create());
    }

    public class OffsetReloadCommand
    implements CommandExecutor {
        public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String cmd, @NotNull String[] args) {
            try {
                CoordinateOffsetCommands.this.plugin.reload();
                CoordinateOffsetCommands.this.replyOk(sender, "Reloaded CoordinateOffset config. Players may need to relog to see the changes.");
            }
            catch (Exception e) {
                CoordinateOffsetCommands.this.replyError(sender, "Failed to reload the config. Check the console for details.");
                e.printStackTrace();
            }
            return true;
        }
    }

    public class OffsetCommand
    implements CommandExecutor {
        public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String cmd, @NotNull String[] args) {
            Object pronoun;
            Player target;
            if (args.length == 0) {
                if (!(sender instanceof Player)) {
                    CoordinateOffsetCommands.this.replyError(sender, "You must be a player or specify a player to query offsets.");
                    return true;
                }
                target = (Player)sender;
                pronoun = "your";
            } else {
                if (!sender.hasPermission("coordinateoffset.query.others")) {
                    sender.sendMessage(Objects.requireNonNull(command.permissionMessage()));
                    return true;
                }
                target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    CoordinateOffsetCommands.this.replyError(sender, "Unknown player \"" + args[0] + "\".");
                    return true;
                }
                pronoun = target.getName() + "'s";
            }
            Offset offset = CoordinateOffsetCommands.this.plugin.getPlayerManager().getOffset(target);
            sender.spigot().sendMessage(new ComponentBuilder(CoordinateOffsetCommands.this.prefix).append("[x=" + offset.x() + ", z=" + offset.z() + "]").color(ChatColor.GOLD).append(" is " + (String)pronoun + " current offset.").color(ChatColor.GREEN).create());
            Location real = target.getLocation();
            sender.spigot().sendMessage(new ComponentBuilder(CoordinateOffsetCommands.this.prefix).append(String.format("(%.1f, %.1f, %.1f)", real.getX(), real.getY(), real.getZ())).color(ChatColor.YELLOW).append(" is " + (String)pronoun + " real position in world ").color(ChatColor.GREEN).append(target.getWorld().getName()).color(ChatColor.YELLOW).append(".").color(ChatColor.GREEN).create());
            return true;
        }
    }
}

