/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.OffsetProvider;
import com.jtprince.coordinateoffset.OffsetProviderContext;
import com.jtprince.coordinateoffset.provider.ConstantOffsetProvider;
import com.jtprince.coordinateoffset.provider.RandomOffsetProvider;
import com.jtprince.coordinateoffset.provider.ZeroAtLocationOffsetProvider;
import com.jtprince.coordinateoffset.provider.util.ResetConfig;
import com.jtprince.lib.org.bstats.bukkit.Metrics;
import com.jtprince.lib.org.bstats.charts.DrilldownPie;
import com.jtprince.lib.org.bstats.charts.SimplePie;
import java.util.HashMap;
import java.util.Map;

public class MetricsWrapper {
    private static final int BSTATS_PLUGIN_METRICS_ID = 19988;

    public static void reportMetrics(CoordinateOffset plugin) {
        Metrics metrics = new Metrics(plugin, 19988);
        metrics.addCustomChart(new DrilldownPie("default_offset_provider", () -> {
            HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
            OffsetProvider defaultProvider = plugin.getOffsetProviderManager().getDefaultProvider();
            if (defaultProvider instanceof ConstantOffsetProvider) {
                result.put("ConstantOffsetProvider", Map.of("ConstantOffsetProvider", 1));
            } else if (defaultProvider instanceof RandomOffsetProvider) {
                RandomOffsetProvider randomOffsetProvider = (RandomOffsetProvider)defaultProvider;
                StringBuilder sb = new StringBuilder();
                sb.append(randomOffsetProvider.isPersistent() ? "Persistent" : "Not Persistent");
                sb.append(" | Reset ");
                ResetConfig rc = randomOffsetProvider.getResetConfig();
                sb.append(rc.resetOn(OffsetProviderContext.ProvideReason.DEATH_RESPAWN) ? "D" : "x");
                sb.append(rc.resetOn(OffsetProviderContext.ProvideReason.WORLD_CHANGE) ? "W" : "x");
                sb.append(rc.resetOn(OffsetProviderContext.ProvideReason.DISTANT_TELEPORT) ? "T" : "x");
                result.put("RandomOffsetProvider", Map.of(sb.toString(), 1));
            } else if (defaultProvider instanceof ZeroAtLocationOffsetProvider) {
                ZeroAtLocationOffsetProvider zeroAtLocationOffsetProvider = (ZeroAtLocationOffsetProvider)defaultProvider;
                StringBuilder sb = new StringBuilder();
                sb.append("Reset ");
                ResetConfig rc = zeroAtLocationOffsetProvider.getResetConfig();
                sb.append(rc.resetOn(OffsetProviderContext.ProvideReason.DEATH_RESPAWN) ? "D" : "x");
                sb.append(rc.resetOn(OffsetProviderContext.ProvideReason.WORLD_CHANGE) ? "W" : "x");
                sb.append(rc.resetOn(OffsetProviderContext.ProvideReason.DISTANT_TELEPORT) ? "T" : "x");
                result.put("ZeroAtLocationOffsetProvider", Map.of(sb.toString(), 1));
            } else {
                result.put("Custom Provider", Map.of("Unknown Offset Provider", 1));
            }
            return result;
        }));
        metrics.addCustomChart(new SimplePie("world_border_obfuscation", () -> {
            if (plugin.getWorldBorderObfuscator().enableObfuscation()) {
                return "enabled";
            }
            return "disabled";
        }));
        metrics.addCustomChart(new SimplePie("unsafe_reset_on_teleport", () -> {
            if (plugin.isUnsafeResetOnTeleportEnabled()) {
                return "enabled";
            }
            return "disabled";
        }));
    }
}

