/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.lib.com.jeff_media.morepersistentdatatypes.DataType;
import com.jtprince.lib.com.jeff_media.morepersistentdatatypes.datatypes.GenericDataType;
import com.jtprince.lib.org.jetbrains.annotations.Contract;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.persistence.PersistentDataType;
import org.checkerframework.dataflow.qual.Pure;

public record Offset(int x, int z) {
    public static final Offset ZERO = new Offset(0, 0);
    public static final PersistentDataType<int[], Offset> PDT_TYPE = new GenericDataType<int[], Offset>(DataType.INTEGER_ARRAY.getPrimitiveType(), Offset.class, Offset::fromPdt, Offset::toPdt);
    public static final int ALIGN_OVERWORLD = 3;

    public Offset {
        if (x % 16 != 0) {
            throw new IllegalArgumentException("Offset x=" + x + " is not aligned with the chunks! (must be a multiple of 16)");
        }
        if (z % 16 != 0) {
            throw new IllegalArgumentException("Offset z=" + z + " is not aligned with the chunks! (must be a multiple of 16)");
        }
    }

    @NotNull
    public static Offset random(int bound) {
        Random random = new Random();
        return Offset.align(random.nextInt(-bound, bound), random.nextInt(-bound, bound), 3);
    }

    @NotNull
    public static Offset align(int x, int z, int toChunksPower) {
        int shift = toChunksPower + 4;
        return new Offset((x += 1 << shift - 1) >> shift << shift, (z += 1 << shift - 1) >> shift << shift);
    }

    @NotNull
    public static Offset align(int x, int z) {
        return Offset.align(x, z, 0);
    }

    public int chunkX() {
        return this.x >> 4;
    }

    public int chunkZ() {
        return this.z >> 4;
    }

    @Pure
    @NotNull
    public Offset scale(int rightShiftAmount) {
        if (rightShiftAmount <= 0) {
            return new Offset(this.x << -rightShiftAmount, this.z << -rightShiftAmount);
        }
        return Offset.align(this.x >> rightShiftAmount, this.z >> rightShiftAmount);
    }

    @Pure
    @NotNull
    public Offset scaleByDouble(double scaleFactor) {
        return Offset.align((int)Math.round((double)this.x * scaleFactor), (int)Math.round((double)this.z * scaleFactor));
    }

    @Pure
    @NotNull
    public Offset negate() {
        return new Offset(-this.x, -this.z);
    }

    @Pure
    @Contract(value="null -> null; !null -> !null")
    public Location apply(Location realLocation) {
        if (realLocation == null) {
            return null;
        }
        return realLocation.clone().subtract((double)this.x, 0.0, (double)this.z);
    }

    @Pure
    @Contract(value="null -> null; !null -> !null")
    public Location unapply(Location offsettedLocation) {
        if (offsettedLocation == null) {
            return null;
        }
        return offsettedLocation.clone().add((double)this.x, 0.0, (double)this.z);
    }

    private static Offset fromPdt(int[] arr) {
        return new Offset(arr[0], arr[1]);
    }

    private int[] toPdt() {
        return new int[]{this.x, this.z};
    }
}

