/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.OffsetProvider;
import com.jtprince.coordinateoffset.OffsetProviderContext;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

class OffsetProviderManager {
    private final CoordinateOffset plugin;
    private final Map<String, OffsetProvider.ConfigurationFactory<?>> configFactories = new HashMap();
    private Map<String, OffsetProvider> providersFromConfig = new HashMap<String, OffsetProvider>();
    private OffsetProvider defaultProvider;
    private List<ProviderOverride> overrides = Collections.emptyList();

    OffsetProviderManager(CoordinateOffset plugin) {
        this.plugin = plugin;
    }

    @NotNull
    private Set<String> getOptionNames() {
        return this.providersFromConfig.keySet();
    }

    void registerConfigurationFactory(@NotNull String className, @NotNull OffsetProvider.ConfigurationFactory<?> factory) {
        this.configFactories.put(className, factory);
    }

    void loadProvidersFromConfig(@NotNull FileConfiguration config) throws IllegalArgumentException {
        ConfigurationSection providerSection = config.getConfigurationSection("offsetProviders");
        if (providerSection == null) {
            throw new IllegalArgumentException("Missing offsetProviders section from config!");
        }
        HashMap<String, OffsetProvider> newProviders = new HashMap<String, OffsetProvider>();
        for (String providerName : providerSection.getKeys(false)) {
            ConfigurationSection section = providerSection.getConfigurationSection(providerName);
            if (section == null) {
                throw new IllegalArgumentException("Offset provider \"" + providerName + "\" is not a valid configuration section.");
            }
            String className = section.getString("class");
            if (className == null) {
                throw new IllegalArgumentException("Offset provider \"" + providerName + "\" is missing a \"class\" field.");
            }
            OffsetProvider.ConfigurationFactory<?> factory = this.configFactories.get(className);
            if (factory == null) {
                throw new IllegalArgumentException("Offset provider \"" + providerName + "\" has an unknown class name " + (String)className + ".");
            }
            Object provider = factory.createProvider(providerName, this.plugin, section);
            newProviders.put(providerName, (OffsetProvider)provider);
        }
        this.providersFromConfig = newProviders;
        String defaultProviderName = config.getString("defaultOffsetProvider");
        if (defaultProviderName == null) {
            throw new IllegalArgumentException("Missing defaultOffsetProvider from config!");
        }
        this.defaultProvider = this.providersFromConfig.get(defaultProviderName);
        if (this.defaultProvider == null) {
            throw new IllegalArgumentException("Unknown defaultOffsetProvider \"" + defaultProviderName + "\". Options are " + String.join((CharSequence)", ", this.getOptionNames()));
        }
        ArrayList<ProviderOverride> newOverrides = new ArrayList<ProviderOverride>();
        List overridesSection = config.getMapList("offsetProviderOverrides");
        for (Map map : overridesSection) {
            Object providerName = map.get("provider");
            if (providerName == null) {
                throw new IllegalArgumentException("All overrides in offsetProviderOverrides must specify a \"provider\" key.");
            }
            OffsetProvider provider = this.providersFromConfig.get(providerName.toString());
            if (provider == null) {
                throw new IllegalArgumentException("Unknown provider \"" + providerName + "\" in offsetProviderOverrides. Options are " + String.join((CharSequence)", ", this.getOptionNames()));
            }
            UUID playerUuid = null;
            if (map.containsKey("playerUuid")) {
                playerUuid = UUID.fromString(map.get("playerUuid").toString());
            }
            String worldName = null;
            if (map.containsKey("world") && Bukkit.getWorld((String)(worldName = map.get("world").toString())) == null) {
                this.plugin.getLogger().warning("Setting a provider override for unloaded world \"" + worldName + "\"!");
            }
            Permission permission = null;
            if (map.containsKey("permission")) {
                String node = map.get("permission").toString();
                permission = Bukkit.getPluginManager().getPermission(node);
                if (permission == null) {
                    permission = new Permission(node);
                    permission.setDefault(PermissionDefault.FALSE);
                    permission.setDescription("A custom permission defined in CoordinateOffset config.yml.");
                    if (permission.getName().startsWith("coordinateoffset.provider.")) {
                        Bukkit.getPluginManager().addPermission(permission);
                    }
                }
            }
            newOverrides.add(new ProviderOverride(provider, playerUuid, worldName, permission));
        }
        this.overrides = newOverrides;
        this.plugin.getLogger().info("Loaded " + newProviders.size() + " offset providers from config. Default offset provider is \"" + this.defaultProvider.name + "\"" + (String)(switch (this.overrides.size()) {
            case 0 -> ".";
            case 1 -> " (+1 override rule).";
            default -> " (+" + this.overrides.size() + " override rules).";
        }));
    }

    OffsetProvider getDefaultProvider() {
        return this.defaultProvider;
    }

    @NotNull
    Offset provideOffset(@NotNull OffsetProviderContext context) {
        Optional<ProviderOverride> appliedOverride;
        OffsetProvider provider = null;
        ProviderSource providerSource = null;
        Offset previousOffset = null;
        try {
            previousOffset = this.plugin.getPlayerManager().getOffset(context.player(), context.world());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (this.plugin.getConfig().getBoolean("bypassByPermission") && context.player().hasPermission("coordinateoffset.bypass")) {
            if (this.plugin.isVerboseLoggingEnabled()) {
                this.plugin.getLogger().info("Bypassing offset with permission for player " + context.player().getName() + ".");
            }
            return Offset.ZERO;
        }
        if (provider == null && (appliedOverride = this.overrides.stream().filter(o -> o.appliesTo(context)).findFirst()).isPresent()) {
            provider = appliedOverride.get().provider;
            providerSource = ProviderSource.OVERRIDE;
        }
        if (provider == null) {
            provider = this.defaultProvider;
            providerSource = ProviderSource.DEFAULT;
        }
        Offset offset = provider.getOffset(context);
        if (this.plugin.isVerboseLoggingEnabled()) {
            String usingOrReusing = offset.equals(previousOffset) ? "Reusing" : "Using";
            String reasonStr = null;
            switch (context.reason()) {
                case JOIN: {
                    reasonStr = "player joined";
                    break;
                }
                case DEATH_RESPAWN: {
                    reasonStr = "player respawned";
                    break;
                }
                case WORLD_CHANGE: {
                    reasonStr = "player changed worlds";
                    break;
                }
                case DISTANT_TELEPORT: {
                    reasonStr = "player teleported";
                }
            }
            String sourceStr = null;
            switch (providerSource) {
                case DEFAULT: {
                    sourceStr = "default provider";
                    break;
                }
                case OVERRIDE: {
                    sourceStr = "config.yml override";
                }
            }
            this.plugin.getLogger().info(usingOrReusing + " " + offset + " from provider \"" + provider.name + "\" (" + sourceStr + ") for player " + context.player().getName() + " in world \"" + context.world().getName() + "\" (" + reasonStr + ").");
        }
        return offset;
    }

    void quitPlayer(@NotNull Player player) {
        for (OffsetProvider provider : this.providersFromConfig.values()) {
            provider.onPlayerQuit(player);
        }
    }

    void disconnectPlayer(@NotNull UUID playerUuid) {
        for (OffsetProvider provider : this.providersFromConfig.values()) {
            provider.onPlayerDisconnect(playerUuid);
        }
    }

    record ProviderOverride(@NotNull OffsetProvider provider, @Nullable UUID playerUuid, @Nullable String worldName, @Nullable Permission permission) {
        boolean appliesTo(OffsetProviderContext context) {
            if (this.playerUuid != null && !this.playerUuid.equals(context.player().getUniqueId())) {
                return false;
            }
            if (this.worldName != null && !this.worldName.equals(context.world().getName())) {
                return false;
            }
            return this.permission == null || context.player().hasPermission(this.permission);
        }
    }

    static enum ProviderSource {
        DEFAULT,
        OVERRIDE;

    }
}

