/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.User;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class PacketDebugger {
    private final CoordinateOffset coPlugin;
    private final Map<User, Deque<LoggedPacket>> history = new HashMap<User, Deque<LoggedPacket>>();

    public PacketDebugger(CoordinateOffset coPlugin) {
        this.coPlugin = coPlugin;
    }

    public void logPacket(User user, PacketTypeCommon type) {
        Deque deque = this.history.computeIfAbsent(user, u -> new ArrayDeque(this.getDebugHistorySize()));
        LoggedPacket last = (LoggedPacket)deque.peekLast();
        if (last != null && last.type == type) {
            ++last.consecutiveCount;
            return;
        }
        if (deque.size() >= this.getDebugHistorySize()) {
            deque.removeFirst();
        }
        deque.addLast(new LoggedPacket(type));
    }

    public String getHistory(User user) {
        Deque<LoggedPacket> deque = this.history.get(user);
        if (deque == null) {
            return "[]";
        }
        return deque.toString();
    }

    public void forget(User user) {
        this.history.remove(user);
    }

    private int getDebugHistorySize() {
        return this.coPlugin.getConfig().getInt("debug.packetHistorySize", 8);
    }

    private static class LoggedPacket {
        private final PacketTypeCommon type;
        private int consecutiveCount = 1;

        private LoggedPacket(PacketTypeCommon type) {
            this.type = type;
        }

        public String toString() {
            char directionIndicator = '?';
            switch (this.type.getSide()) {
                case SERVER: {
                    directionIndicator = '>';
                    break;
                }
                case CLIENT: {
                    directionIndicator = '<';
                }
            }
            return directionIndicator + this.type.getName() + "(" + this.consecutiveCount + ")";
        }
    }
}

