/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.PacketDebugger;
import com.jtprince.coordinateoffset.offsetter.OffsetterRegistry;
import com.jtprince.lib.com.github.retrooper.packetevents.PacketEvents;
import com.jtprince.lib.com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.jtprince.lib.com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.jtprince.lib.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.PacketSendEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.UserDisconnectEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.jtprince.util.PartialStacktraceLogger;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

class PacketOffsetAdapter {
    private final CoordinateOffset coPlugin;
    private final Logger logger;
    private final PacketDebugger packetHistory;

    PacketOffsetAdapter(CoordinateOffset plugin) {
        this.coPlugin = plugin;
        this.logger = plugin.getLogger();
        this.packetHistory = new PacketDebugger(plugin);
    }

    void registerAdapters() {
        PacketEvents.getAPI().getEventManager().registerListener(new Listener());
        PacketEvents.getAPI().init();
    }

    private class Listener
    extends PacketListenerAbstract {
        private static final Set<PacketType.Play.Server> PACKETS_WORLD_BORDER = Set.of(PacketType.Play.Server.INITIALIZE_WORLD_BORDER, PacketType.Play.Server.WORLD_BORDER_CENTER, PacketType.Play.Server.WORLD_BORDER_LERP_SIZE, PacketType.Play.Server.WORLD_BORDER_SIZE, PacketType.Play.Server.WORLD_BORDER_WARNING_DELAY, PacketType.Play.Server.WORLD_BORDER_WARNING_REACH);

        Listener() {
            super(PacketListenerPriority.HIGH);
        }

        @Override
        public void onPacketSend(PacketSendEvent event) {
            block9: {
                if (PacketOffsetAdapter.this.coPlugin.isDebugEnabled()) {
                    PacketOffsetAdapter.this.packetHistory.logPacket(event.getUser(), event.getPacketType());
                }
                try {
                    Offset offset;
                    Player player;
                    if ((event.getPacketType() == PacketType.Play.Server.PLAYER_POSITION_AND_LOOK || event.getPacketType() == PacketType.Play.Server.UPDATE_VIEW_POSITION) && (player = (Player)event.getPlayer()) != null) {
                        PacketOffsetAdapter.this.coPlugin.getPlayerManager().setPositionedWorld(player, player.getWorld());
                    }
                    if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME || event.getPacketType() == PacketType.Play.Server.RESPAWN) {
                        offset = PacketOffsetAdapter.this.coPlugin.getPlayerManager().getOffsetLookahead(event.getUser().getUUID());
                    } else {
                        if (event.getPlayer() == null) {
                            return;
                        }
                        offset = PacketOffsetAdapter.this.coPlugin.getPlayerManager().getOffset((Player)event.getPlayer());
                    }
                    if (offset.equals(Offset.ZERO)) {
                        return;
                    }
                    if (PACKETS_WORLD_BORDER.contains(event.getPacketType())) {
                        PacketOffsetAdapter.this.coPlugin.getWorldBorderObfuscator().translate(event, (Player)event.getPlayer());
                        return;
                    }
                    OffsetterRegistry.attemptToOffset(event, offset);
                }
                catch (Exception e) {
                    PartialStacktraceLogger.logStacktrace(PacketOffsetAdapter.this.logger, "Failed to apply offset for outgoing packet " + event.getPacketType().getName() + " to " + event.getUser().getName(), e);
                    if (!PacketOffsetAdapter.this.coPlugin.isDebugEnabled()) break block9;
                    PacketOffsetAdapter.this.logger.warning("Packet history for above stacktrace: " + PacketOffsetAdapter.this.packetHistory.getHistory(event.getUser()));
                }
            }
        }

        @Override
        public void onPacketReceive(PacketReceiveEvent event) {
            block5: {
                if (PacketOffsetAdapter.this.coPlugin.isDebugEnabled()) {
                    PacketOffsetAdapter.this.packetHistory.logPacket(event.getUser(), event.getPacketType());
                }
                try {
                    Player player = (Player)event.getPlayer();
                    if (player == null) {
                        return;
                    }
                    Offset offset = PacketOffsetAdapter.this.coPlugin.getPlayerManager().getOffset(player, player.getWorld());
                    if (offset.equals(Offset.ZERO)) {
                        return;
                    }
                    OffsetterRegistry.attemptToUnOffset(event, offset);
                }
                catch (Exception e) {
                    PartialStacktraceLogger.logStacktrace(PacketOffsetAdapter.this.logger, "Failed to reverse offset for incoming packet " + event.getPacketType().getName() + " from " + event.getUser().getName(), e);
                    if (!PacketOffsetAdapter.this.coPlugin.isDebugEnabled()) break block5;
                    PacketOffsetAdapter.this.logger.warning("Packet history for above stacktrace: " + PacketOffsetAdapter.this.packetHistory.getHistory(event.getUser()));
                }
            }
        }

        @Override
        public void onUserDisconnect(UserDisconnectEvent event) {
            UUID playerUuid = event.getUser().getUUID();
            if (playerUuid == null) {
                return;
            }
            Player onlinePlayer = Bukkit.getPlayer((UUID)playerUuid);
            if (onlinePlayer != null && PacketEvents.getAPI().getPlayerManager().getUser(onlinePlayer) != event.getUser()) {
                return;
            }
            PacketOffsetAdapter.this.coPlugin.getPlayerManager().remove(playerUuid);
            PacketOffsetAdapter.this.coPlugin.getOffsetProviderManager().disconnectPlayer(playerUuid);
            PacketOffsetAdapter.this.coPlugin.getWorldBorderObfuscator().onPlayerDisconnect(playerUuid);
            if (PacketOffsetAdapter.this.coPlugin.isDebugEnabled()) {
                PacketOffsetAdapter.this.packetHistory.forget(event.getUser());
            }
        }
    }
}

