/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.OffsetProviderContext;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;

class PlayerOffsetsManager {
    private final CoordinateOffset plugin;
    private final Map<UUID, Map<UUID, Offset>> playerOffsets = new HashMap<UUID, Map<UUID, Offset>>();
    private final Map<UUID, UUID> playerPositionedWorld = new HashMap<UUID, UUID>();
    private final Map<UUID, UUID> playerLookaheadWorld = new HashMap<UUID, UUID>();

    PlayerOffsetsManager(CoordinateOffset plugin) {
        this.plugin = plugin;
    }

    @NotNull
    synchronized Offset getOffset(@NotNull Player player) {
        Map<UUID, Offset> offsetPerWorldCache = this.getPerWorldCacheFor(player.getUniqueId(), player.getName());
        UUID positionedWorld = this.playerPositionedWorld.get(player.getUniqueId());
        if (positionedWorld == null) {
            throw new NoSuchElementException("Can't determine which world player is in: " + player.getName());
        }
        return offsetPerWorldCache.get(positionedWorld);
    }

    @NotNull
    synchronized Offset getOffset(@NotNull Player player, @NotNull World world) {
        Map<UUID, Offset> offsetPerWorldCache = this.getPerWorldCacheFor(player.getUniqueId(), player.getName());
        return offsetPerWorldCache.get(world.getUID());
    }

    @NotNull
    synchronized Offset getOffsetLookahead(@NotNull UUID playerUuid) {
        Map<UUID, Offset> offsetPerWorldCache = this.getPerWorldCacheFor(playerUuid, playerUuid.toString());
        UUID respawningWorld = this.playerLookaheadWorld.get(playerUuid);
        if (respawningWorld == null) {
            throw new NoSuchElementException("Can't determine which world player is in: " + playerUuid);
        }
        return offsetPerWorldCache.get(respawningWorld);
    }

    @NotNull
    private Map<UUID, Offset> getPerWorldCacheFor(UUID player, String logName) {
        Map<UUID, Offset> offsetPerWorldCache = this.playerOffsets.get(player);
        if (offsetPerWorldCache == null) {
            throw new NoSuchElementException("Unknown player for Offset lookup: " + logName);
        }
        return offsetPerWorldCache;
    }

    synchronized void regenerateOffset(OffsetProviderContext context) {
        Offset newOffset = this.plugin.getOffsetProviderManager().provideOffset(context);
        Map offsetPerWorldCache = this.playerOffsets.computeIfAbsent(context.player().getUniqueId(), k -> new HashMap());
        offsetPerWorldCache.put(context.world().getUID(), newOffset);
        this.playerLookaheadWorld.put(context.player().getUniqueId(), context.world().getUID());
    }

    synchronized void setPositionedWorld(Player player, World world) {
        this.playerPositionedWorld.put(player.getUniqueId(), world.getUID());
    }

    synchronized void remove(@NotNull UUID uuid) {
        this.playerOffsets.remove(uuid);
        this.playerLookaheadWorld.remove(uuid);
        this.playerPositionedWorld.remove(uuid);
    }
}

