/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.lib.com.github.retrooper.packetevents.event.PacketSendEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerInitializeWorldBorder;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWorldBorderCenter;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWorldBorderSize;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayWorldBorderLerpSize;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;

class WorldBorderObfuscator {
    private static final double BASELINE_SIZE = 6.0E7;
    private final CoordinateOffset plugin;
    private final Map<UUID, EnumSet<Wall>> knownSeenWalls = new HashMap<UUID, EnumSet<Wall>>();

    WorldBorderObfuscator(CoordinateOffset plugin) {
        this.plugin = plugin;
    }

    void tryUpdatePlayerBorders(Player player, Location movingTo) {
        EnumSet<Wall> currentlyVisible = this.visibleBorders(movingTo);
        if (!currentlyVisible.equals(this.knownSeenWalls.get(player.getUniqueId()))) {
            this.plugin.getLogger().fine("Seen walls update for " + player.getName() + ": " + currentlyVisible);
            this.knownSeenWalls.put(player.getUniqueId(), currentlyVisible);
            if (player.isOnline() && this.enableObfuscation()) {
                try {
                    player.setWorldBorder(player.getWorldBorder());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }

    void onPlayerDisconnect(UUID playerUuid) {
        this.knownSeenWalls.remove(playerUuid);
    }

    boolean enableObfuscation() {
        return this.plugin.getConfig().getBoolean("obfuscateWorldBorder");
    }

    private EnumSet<Wall> visibleBorders(Location location) {
        double viewDistanceBlocks = Objects.requireNonNull(location.getWorld()).getViewDistance() * 16;
        WorldBorder realBorder = location.getWorld().getWorldBorder();
        double xMax = realBorder.getCenter().getX() + realBorder.getSize() / 2.0;
        double xMin = realBorder.getCenter().getX() - realBorder.getSize() / 2.0;
        double zMax = realBorder.getCenter().getZ() + realBorder.getSize() / 2.0;
        double zMin = realBorder.getCenter().getZ() - realBorder.getSize() / 2.0;
        EnumSet<Wall> seen = EnumSet.noneOf(Wall.class);
        if (xMax - location.getX() < viewDistanceBlocks) {
            seen.add(Wall.X_POSITIVE);
        }
        if (location.getX() - xMin < viewDistanceBlocks) {
            seen.add(Wall.X_NEGATIVE);
        }
        if (zMax - location.getZ() < viewDistanceBlocks) {
            seen.add(Wall.Z_POSITIVE);
        }
        if (location.getZ() - zMin < viewDistanceBlocks) {
            seen.add(Wall.Z_NEGATIVE);
        }
        return seen;
    }

    void translate(@NotNull PacketSendEvent packet, @NotNull Player player) {
        WorldBorder border;
        Offset offset = this.plugin.getPlayerManager().getOffset(player);
        double scaleFactor = player.getWorld().getEnvironment() == World.Environment.NETHER ? 8.0 : 1.0;
        EnumSet<Wall> seenWalls = this.knownSeenWalls.getOrDefault(player.getUniqueId(), EnumSet.noneOf(Wall.class));
        if (!this.enableObfuscation() || seenWalls.contains((Object)Wall.X_POSITIVE) && seenWalls.contains((Object)Wall.X_NEGATIVE) || seenWalls.contains((Object)Wall.Z_POSITIVE) && seenWalls.contains((Object)Wall.Z_NEGATIVE)) {
            if (packet.getPacketType().equals(PacketType.Play.Server.INITIALIZE_WORLD_BORDER)) {
                WrapperPlayServerInitializeWorldBorder wrapper = new WrapperPlayServerInitializeWorldBorder(packet);
                wrapper.setX(wrapper.getX() - (double)offset.x() * scaleFactor);
                wrapper.setZ(wrapper.getZ() - (double)offset.z() * scaleFactor);
                wrapper.setPortalTeleportBoundary(60000000);
            } else if (packet.getPacketType().equals(PacketType.Play.Server.WORLD_BORDER_CENTER)) {
                WrapperPlayServerWorldBorderCenter wrapper = new WrapperPlayServerWorldBorderCenter(packet);
                wrapper.setX(wrapper.getX() - (double)offset.x() * scaleFactor);
                wrapper.setZ(wrapper.getZ() - (double)offset.z() * scaleFactor);
            }
            return;
        }
        try {
            border = player.getWorldBorder();
        }
        catch (NoSuchMethodError e) {
            packet.setCancelled(true);
            return;
        }
        if (border == null) {
            border = player.getWorld().getWorldBorder();
        }
        double centerX = 0.0;
        double centerZ = 0.0;
        double diameter = 6.0E7;
        if (seenWalls.size() >= 1) {
            if (seenWalls.contains((Object)Wall.X_POSITIVE)) {
                double realXMax = border.getCenter().getX() + border.getSize() / 2.0;
                centerX = realXMax - 3.0E7;
                centerX -= (double)offset.x();
            }
            if (seenWalls.contains((Object)Wall.X_NEGATIVE)) {
                double realXMin = border.getCenter().getX() - border.getSize() / 2.0;
                centerX = realXMin + 3.0E7;
                centerX -= (double)offset.x();
            }
            if (seenWalls.contains((Object)Wall.Z_POSITIVE)) {
                double realZMax = border.getCenter().getZ() + border.getSize() / 2.0;
                centerZ = realZMax - 3.0E7;
                centerZ -= (double)offset.z();
            }
            if (seenWalls.contains((Object)Wall.Z_NEGATIVE)) {
                double realZMin = border.getCenter().getZ() - border.getSize() / 2.0;
                centerZ = realZMin + 3.0E7;
                centerZ -= (double)offset.z();
            }
        } else {
            centerZ = 0.0;
            centerX = 0.0;
        }
        if (packet.getPacketType().equals(PacketType.Play.Server.INITIALIZE_WORLD_BORDER)) {
            WrapperPlayServerInitializeWorldBorder wrapper = new WrapperPlayServerInitializeWorldBorder(packet);
            wrapper.setX(centerX * scaleFactor);
            wrapper.setZ(centerZ * scaleFactor);
            wrapper.setOldDiameter(6.0E7);
            wrapper.setNewDiameter(6.0E7);
            wrapper.setPortalTeleportBoundary(60000000);
        } else if (packet.getPacketType().equals(PacketType.Play.Server.WORLD_BORDER_CENTER)) {
            WrapperPlayServerWorldBorderCenter wrapper = new WrapperPlayServerWorldBorderCenter(packet);
            wrapper.setX(centerX * scaleFactor);
            wrapper.setZ(centerZ * scaleFactor);
        } else if (packet.getPacketType().equals(PacketType.Play.Server.WORLD_BORDER_LERP_SIZE)) {
            WrapperPlayWorldBorderLerpSize wrapper = new WrapperPlayWorldBorderLerpSize(packet);
            wrapper.setOldDiameter(6.0E7);
            wrapper.setNewDiameter(6.0E7);
        } else if (packet.getPacketType().equals(PacketType.Play.Server.WORLD_BORDER_SIZE)) {
            WrapperPlayServerWorldBorderSize wrapper = new WrapperPlayServerWorldBorderSize(packet);
            wrapper.setDiameter(6.0E7);
        }
    }

    static enum Wall {
        X_POSITIVE,
        X_NEGATIVE,
        Z_POSITIVE,
        Z_NEGATIVE;

    }
}

