/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter;

import com.jtprince.coordinateoffset.Offset;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.User;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.Column;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.TileEntity;

public class OffsettedColumn
extends Column {
    private final Column inner;
    private final Offset offset;
    private final User user;
    private static final BaseChunk[] emptyChunkList = new BaseChunk[0];

    public OffsettedColumn(Column column, Offset offset, User user) {
        super(0, 0, false, emptyChunkList, null);
        this.inner = column;
        this.offset = offset;
        this.user = user;
    }

    @Override
    public int getX() {
        return this.inner.getX() - this.offset.chunkX();
    }

    @Override
    public int getZ() {
        return this.inner.getZ() - this.offset.chunkZ();
    }

    @Override
    public boolean isFullChunk() {
        return this.inner.isFullChunk();
    }

    @Override
    public BaseChunk[] getChunks() {
        return this.inner.getChunks();
    }

    @Override
    public TileEntity[] getTileEntities() {
        if (this.user.getClientVersion().isOlderThan(ClientVersion.V_1_18)) {
            TileEntity[] entities;
            for (TileEntity entity : entities = this.inner.getTileEntities()) {
                entity.setX(entity.getX() - this.offset.x());
                entity.setZ(entity.getZ() - this.offset.z());
            }
            return entities;
        }
        return this.inner.getTileEntities();
    }

    @Override
    public boolean hasHeightMaps() {
        return this.inner.hasHeightMaps();
    }

    @Override
    public NBTCompound getHeightMaps() {
        return this.inner.getHeightMaps();
    }

    @Override
    public boolean hasBiomeData() {
        return this.inner.hasBiomeData();
    }

    @Override
    public int[] getBiomeDataInts() {
        return this.inner.getBiomeDataInts();
    }

    @Override
    public byte[] getBiomeDataBytes() {
        return this.inner.getBiomeDataBytes();
    }
}

