/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter;

import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.offsetter.PacketOffsetter;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientClickWindow;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientCreativeInventoryAction;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientGenerateStructure;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientPlayerBlockPlacement;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientPlayerDigging;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientPlayerPosition;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientUpdateCommandBlock;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientUpdateJigsawBlock;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientUpdateSign;
import com.jtprince.coordinateoffset.offsetter.client.OffsetterClientVehicleMove;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerAcknowledgePlayerDigging;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerBlockAction;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerBlockBreakAnimation;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerBlockChange;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerBlockEntityData;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerChunkData;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerEffect;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerEntityEquipment;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerEntityMetadata;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerEntityPositionSync;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerEntityTeleport;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerExplosion;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerFacePlayer;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerJoinGame;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerMoveMinecart;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerMultiBlockChange;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerNamedSoundEffect;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerOpenSignEditor;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerParticle;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerPlayerPositionAndLook;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerRespawn;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerSculkVibrationSignal;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerSetSlot;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerSoundEffect;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerSpawnEntity;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerSpawnExperienceOrb;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerSpawnLivingEntity;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerSpawnPainting;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerSpawnPlayer;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerSpawnPosition;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerUnloadChunk;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerUpdateLight;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerUpdateViewPosition;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerVehicleMove;
import com.jtprince.coordinateoffset.offsetter.server.OffsetterServerWindowItems;
import com.jtprince.lib.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.event.PacketSendEvent;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OffsetterRegistry {
    private static final Map<PacketTypeCommon, PacketOffsetter> byPacketType;
    private static final List<PacketOffsetter> offsetters;

    public static void attemptToOffset(PacketSendEvent event, Offset offset) {
        PacketOffsetter associatedOffsetter = byPacketType.get(event.getPacketType());
        if (associatedOffsetter == null) {
            return;
        }
        try {
            PacketWrapper wrapper = (PacketWrapper)associatedOffsetter.wrapperClass.getConstructor(PacketSendEvent.class).newInstance(event);
            associatedOffsetter.offset(wrapper, offset, event.getUser());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void attemptToUnOffset(PacketReceiveEvent event, Offset offset) {
        PacketOffsetter associatedOffsetter = byPacketType.get(event.getPacketType());
        if (associatedOffsetter == null) {
            return;
        }
        try {
            PacketWrapper wrapper = (PacketWrapper)associatedOffsetter.wrapperClass.getConstructor(PacketReceiveEvent.class).newInstance(event);
            associatedOffsetter.offset(wrapper, offset, event.getUser());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        offsetters = List.of(new OffsetterClientClickWindow(), new OffsetterClientCreativeInventoryAction(), new OffsetterClientGenerateStructure(), new OffsetterClientPlayerBlockPlacement(), new OffsetterClientPlayerDigging(), new OffsetterClientPlayerPosition(), new OffsetterClientUpdateCommandBlock(), new OffsetterClientUpdateJigsawBlock(), new OffsetterClientUpdateSign(), new OffsetterClientVehicleMove(), new OffsetterServerAcknowledgePlayerDigging(), new OffsetterServerBlockAction(), new OffsetterServerBlockBreakAnimation(), new OffsetterServerBlockChange(), new OffsetterServerBlockEntityData(), new OffsetterServerChunkData(), new OffsetterServerEffect(), new OffsetterServerEntityEquipment(), new OffsetterServerEntityMetadata(), new OffsetterServerEntityPositionSync(), new OffsetterServerEntityTeleport(), new OffsetterServerExplosion(), new OffsetterServerFacePlayer(), new OffsetterServerJoinGame(), new OffsetterServerUpdateLight(), new OffsetterServerMoveMinecart(), new OffsetterServerMultiBlockChange(), new OffsetterServerNamedSoundEffect(), new OffsetterServerOpenSignEditor(), new OffsetterServerParticle(), new OffsetterServerPlayerPositionAndLook(), new OffsetterServerRespawn(), new OffsetterServerSculkVibrationSignal(), new OffsetterServerSetSlot(), new OffsetterServerSoundEffect(), new OffsetterServerSpawnEntity(), new OffsetterServerSpawnExperienceOrb(), new OffsetterServerSpawnLivingEntity(), new OffsetterServerSpawnPainting(), new OffsetterServerSpawnPlayer(), new OffsetterServerSpawnPosition(), new OffsetterServerUnloadChunk(), new OffsetterServerUpdateViewPosition(), new OffsetterServerVehicleMove(), new OffsetterServerWindowItems());
        byPacketType = new HashMap<PacketTypeCommon, PacketOffsetter>();
        for (PacketOffsetter offsetter : offsetters) {
            for (PacketTypeCommon type : offsetter.packetTypes) {
                byPacketType.put(type, offsetter);
            }
        }
    }
}

