/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.offsetter.OffsettedColumn;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.component.ComponentTypes;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.component.builtin.item.LodestoneTracker;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.User;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.Location;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.WorldBlockPosition;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.chunk.Column;
import com.jtprince.lib.com.github.retrooper.packetevents.util.Vector3d;
import com.jtprince.lib.com.github.retrooper.packetevents.util.Vector3i;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Optional;

public abstract class PacketOffsetter<T extends PacketWrapper<T>> {
    public final PacketTypeCommon[] packetTypes;
    public final Class<T> wrapperClass;

    public PacketOffsetter(Class<T> wrapperClass, PacketTypeCommon ... packetTypes) {
        this.packetTypes = packetTypes;
        this.wrapperClass = wrapperClass;
    }

    public abstract void offset(T var1, Offset var2, User var3);

    protected static Vector3d apply(Vector3d vec, Offset offset) {
        return new Vector3d(vec.x - (double)offset.x(), vec.y, vec.z - (double)offset.z());
    }

    protected static Vector3i apply(Vector3i vec, Offset offset) {
        return new Vector3i(vec.x - offset.x(), vec.y, vec.z - offset.z());
    }

    protected static Vector3d unapply(Vector3d vec, Offset offset) {
        return new Vector3d(vec.x + (double)offset.x(), vec.y, vec.z + (double)offset.z());
    }

    protected static Vector3i unapply(Vector3i vec, Offset offset) {
        return new Vector3i(vec.x + offset.x(), vec.y, vec.z + offset.z());
    }

    protected static Location unapply(Location loc, Offset offset) {
        loc.setPosition(new Vector3d(loc.getX() + (double)offset.x(), loc.getY(), loc.getZ() + (double)offset.z()));
        return loc;
    }

    protected static WorldBlockPosition apply(WorldBlockPosition pos, Offset offset) {
        return new WorldBlockPosition(pos.getWorld(), pos.getBlockPosition().x - offset.x(), pos.getBlockPosition().y, pos.getBlockPosition().z - offset.z());
    }

    protected static Vector3i applyChunk(Vector3i vec, Offset offset) {
        return new Vector3i(vec.x - offset.chunkX(), vec.y, vec.z - offset.chunkZ());
    }

    protected static double applyX(double x, Offset offset) {
        return x - (double)offset.x();
    }

    protected static double applyZ(double z, Offset offset) {
        return z - (double)offset.z();
    }

    protected static int applyChunkX(int chunkX, Offset offset) {
        return chunkX - offset.chunkX();
    }

    protected static int applyChunkZ(int chunkZ, Offset offset) {
        return chunkZ - offset.chunkZ();
    }

    protected static OffsettedColumn applyColumn(Column column, Offset offset, User user) {
        if (column instanceof OffsettedColumn) {
            return (OffsettedColumn)column;
        }
        return new OffsettedColumn(column, offset, user);
    }

    protected static Vector3i applyTimes8(Vector3i vec, Offset offset) {
        return new Vector3i(vec.x - offset.x() * 8, vec.y, vec.z - offset.z() * 8);
    }

    protected static ItemStack applyItemStack(ItemStack item, Offset offset) {
        if (item == null) {
            return null;
        }
        if (item.getType() == ItemTypes.COMPASS) {
            LodestoneTracker lodestone;
            Object obj;
            NBTCompound lodestonePos;
            NBTCompound nbt = item.getNBT();
            if (nbt != null && (lodestonePos = nbt.getCompoundTagOrNull("LodestonePos")) != null) {
                lodestonePos.setTag("X", new NBTInt(lodestonePos.getNumberTagOrThrow("X").getAsInt() - offset.x()));
                lodestonePos.setTag("Z", new NBTInt(lodestonePos.getNumberTagOrThrow("Z").getAsInt() - offset.z()));
            }
            Optional<?> lodestoneComponent = null;
            try {
                lodestoneComponent = item.getComponents().getPatches().get(ComponentTypes.LODESTONE_TRACKER);
            }
            catch (NoSuchMethodError e) {
                CoordinateOffset.getInstance().getLogger().fine("Outdated PacketEvents! Failed to get item components.");
            }
            if (lodestoneComponent != null && lodestoneComponent.isPresent() && (obj = lodestoneComponent.get()) instanceof LodestoneTracker && (lodestone = (LodestoneTracker)obj).getTarget() != null) {
                lodestone.setTarget(PacketOffsetter.apply(lodestone.getTarget(), offset));
            }
        }
        return item;
    }

    protected static ItemStack unapplyItemStack(ItemStack item, Offset offset) {
        return PacketOffsetter.applyItemStack(item, offset.negate());
    }
}

