/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.offsetter.server;

import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.offsetter.PacketOffsetter;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.User;
import com.jtprince.lib.com.github.retrooper.packetevents.util.Vector3i;
import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import java.util.Optional;

public class OffsetterServerEntityMetadata
extends PacketOffsetter<WrapperPlayServerEntityMetadata> {
    public OffsetterServerEntityMetadata() {
        super(WrapperPlayServerEntityMetadata.class, PacketType.Play.Server.ENTITY_METADATA);
    }

    @Override
    public void offset(WrapperPlayServerEntityMetadata packet, Offset offset, User user) {
        for (EntityData data : packet.getEntityMetadata()) {
            Object value = data.getValue();
            if (value == null) continue;
            if (value instanceof Optional) {
                Optional optional = (Optional)value;
                if (!optional.isPresent()) continue;
                data.setValue(Optional.of(OffsetterServerEntityMetadata.applyOffsetToEntityMeta(optional.get(), offset)));
                continue;
            }
            data.setValue(OffsetterServerEntityMetadata.applyOffsetToEntityMeta(value, offset));
        }
    }

    private static Object applyOffsetToEntityMeta(Object object, Offset offset) {
        if (object instanceof Vector3i) {
            Vector3i blockPosition = (Vector3i)object;
            return blockPosition.add(-offset.x(), 0, -offset.z());
        }
        if (object instanceof ItemStack) {
            return OffsetterServerEntityMetadata.applyItemStack((ItemStack)object, offset);
        }
        return object;
    }
}

