/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.OffsetProvider;
import com.jtprince.coordinateoffset.OffsetProviderContext;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public class ConstantOffsetProvider
extends OffsetProvider {
    final Offset offset;
    final Map<String, Double> worldScaling;

    private ConstantOffsetProvider(String name, Offset offset, Map<String, Double> worldScaling) {
        super(name);
        this.offset = offset;
        this.worldScaling = worldScaling;
    }

    @Override
    @NotNull
    public Offset getOffset(@NotNull OffsetProviderContext context) {
        Double scaling = this.worldScaling.get(context.world().getName());
        if (scaling != null) {
            return this.offset.scaleByDouble(scaling);
        }
        return this.offset;
    }

    public static class ConfigFactory
    implements OffsetProvider.ConfigurationFactory<ConstantOffsetProvider> {
        @Override
        @NotNull
        public ConstantOffsetProvider createProvider(@NotNull String name, @NotNull CoordinateOffset plugin, @NotNull ConfigurationSection providerConfig) throws IllegalArgumentException {
            if (!providerConfig.isInt("offsetX")) {
                throw new IllegalArgumentException("Missing field offsetX for ConstantOffsetProvider.");
            }
            if (!providerConfig.isInt("offsetZ")) {
                throw new IllegalArgumentException("Missing field offsetZ for ConstantOffsetProvider.");
            }
            int offsetX = providerConfig.getInt("offsetX");
            int offsetZ = providerConfig.getInt("offsetZ");
            if (offsetX > OffsetProvider.OFFSET_MAX) {
                throw new IllegalArgumentException("Provider \"" + name + "\": offsetX is too large! (Max 30M)");
            }
            if (offsetZ > OffsetProvider.OFFSET_MAX) {
                throw new IllegalArgumentException("Provider \"" + name + "\": offsetZ is too large! (Max 30M)");
            }
            HashMap<String, Double> worldScaling = new HashMap<String, Double>();
            if (providerConfig.isConfigurationSection("worldScaling")) {
                ConfigurationSection section = Objects.requireNonNull(providerConfig.getConfigurationSection("worldScaling"));
                for (Map.Entry entry : section.getValues(false).entrySet()) {
                    Object v = entry.getValue();
                    if (v instanceof Number) {
                        Number n = (Number)v;
                        worldScaling.put((String)entry.getKey(), n.doubleValue());
                        continue;
                    }
                    throw new IllegalArgumentException("Provider \"" + name + "\": World scaling for world \"" + (String)entry.getKey() + "\" must be a number!");
                }
            }
            return new ConstantOffsetProvider(name, new Offset(offsetX, offsetZ), worldScaling);
        }
    }
}

