/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.OffsetProvider;
import com.jtprince.coordinateoffset.OffsetProviderContext;
import com.jtprince.coordinateoffset.provider.util.PerWorldOffsetStore;
import com.jtprince.coordinateoffset.provider.util.ResetConfig;
import com.jtprince.coordinateoffset.provider.util.WorldAlignmentConfig;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class RandomOffsetProvider
extends OffsetProvider {
    private static final String DEFAULT_PERSISTENCE_KEY = "default";
    private ResetConfig resetConfig;
    private int randomBound;
    private WorldAlignmentConfig worldAlignment;
    private final PerWorldOffsetStore perWorldOffsetStore;

    private RandomOffsetProvider(String name, @Nullable String persistenceKey, CoordinateOffset plugin) {
        super(name);
        if (persistenceKey == null) {
            this.perWorldOffsetStore = new PerWorldOffsetStore.Cached();
        } else {
            NamespacedKey key = new NamespacedKey((Plugin)plugin, "random-persistence." + persistenceKey);
            this.perWorldOffsetStore = new PerWorldOffsetStore.Persistent(key);
        }
    }

    @Override
    @NotNull
    public Offset getOffset(@NotNull OffsetProviderContext context) {
        Offset alignedWorldOffset;
        Offset offset;
        if (this.resetConfig.resetOn(context.reason())) {
            this.perWorldOffsetStore.reset(context.player().getUniqueId());
        }
        if ((offset = this.perWorldOffsetStore.get(context.player(), context.world().getName())) != null) {
            return offset;
        }
        WorldAlignmentConfig.QueryResult alignment = this.worldAlignment.findAlignment(context.world().getName());
        if (alignment != null && (alignedWorldOffset = this.perWorldOffsetStore.get(context.player(), alignment.targetWorldName())) != null) {
            offset = alignedWorldOffset.scale(alignment.rightShiftAmount());
            if (context.plugin().isVerboseLoggingEnabled()) {
                Object scaleStr = alignment.rightShiftAmount() == 0 ? "." : (alignment.rightShiftAmount() < 0 ? " (scaled up by " + (1 << -alignment.rightShiftAmount()) + ")." : " (scaled down by " + (1 << alignment.rightShiftAmount()) + ").");
                context.plugin().getLogger().info("Provider \"" + this.name + "\": Aligning new offset for world \"" + context.world().getName() + "\" to existing " + alignedWorldOffset + " from world \"" + alignment.targetWorldName() + "\"" + (String)scaleStr);
            }
        }
        if (offset == null) {
            offset = Offset.random(this.randomBound);
        }
        this.perWorldOffsetStore.put(context.player(), context.world().getName(), offset);
        return offset;
    }

    @Override
    public void onPlayerDisconnect(@NotNull UUID playerUuid) {
        if (this.perWorldOffsetStore instanceof PerWorldOffsetStore.Cached) {
            this.perWorldOffsetStore.reset(playerUuid);
        }
    }

    public boolean isPersistent() {
        return this.perWorldOffsetStore instanceof PerWorldOffsetStore.Persistent;
    }

    public ResetConfig getResetConfig() {
        return this.resetConfig;
    }

    public static class ConfigFactory
    implements OffsetProvider.ConfigurationFactory<RandomOffsetProvider> {
        @Override
        @NotNull
        public RandomOffsetProvider createProvider(@NotNull String name, @NotNull CoordinateOffset plugin, @NotNull ConfigurationSection providerConfig) throws IllegalArgumentException {
            if (!providerConfig.isInt("randomBound")) {
                throw new IllegalArgumentException("Missing field randomBound for RandomOffsetProvider.");
            }
            boolean persistent = providerConfig.getBoolean("persistent");
            String persistenceKey = providerConfig.getString("persistenceKey", RandomOffsetProvider.DEFAULT_PERSISTENCE_KEY);
            if (!persistent && !persistenceKey.equals(RandomOffsetProvider.DEFAULT_PERSISTENCE_KEY)) {
                plugin.getLogger().warning("Provider \"" + name + "\": Defined a persistence key when persistence is disabled!");
            }
            RandomOffsetProvider p = new RandomOffsetProvider(name, persistent ? persistenceKey : null, plugin);
            p.resetConfig = ResetConfig.fromConfigSection(providerConfig);
            p.randomBound = providerConfig.getInt("randomBound");
            if (p.randomBound > OffsetProvider.OFFSET_MAX) {
                throw new IllegalArgumentException("Provider \"" + name + "\": randomBound is too large! (Max 30M)");
            }
            p.worldAlignment = WorldAlignmentConfig.fromConfig(providerConfig.getStringList("worldAlignment"));
            return p;
        }
    }
}

