/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.coordinateoffset.OffsetProvider;
import com.jtprince.coordinateoffset.OffsetProviderContext;
import com.jtprince.coordinateoffset.provider.util.PerWorldOffsetStore;
import com.jtprince.coordinateoffset.provider.util.ResetConfig;
import com.jtprince.coordinateoffset.provider.util.WorldAlignmentConfig;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class ZeroAtLocationOffsetProvider
extends OffsetProvider {
    private ResetConfig resetConfig;
    private WorldAlignmentConfig worldAlignment;
    private final PerWorldOffsetStore perWorldOffsetStore = new PerWorldOffsetStore.Cached();

    private ZeroAtLocationOffsetProvider(String name) {
        super(name);
    }

    @Override
    @NotNull
    public Offset getOffset(@NotNull OffsetProviderContext context) {
        Offset alignedWorldOffset;
        Offset offset;
        if (this.resetConfig.resetOn(context.reason())) {
            this.perWorldOffsetStore.reset(context.player());
        }
        if ((offset = this.perWorldOffsetStore.get(context.player(), context.world().getName())) != null) {
            return offset;
        }
        WorldAlignmentConfig.QueryResult alignment = this.worldAlignment.findAlignment(context.world().getName());
        if (alignment != null && (alignedWorldOffset = this.perWorldOffsetStore.get(context.player(), alignment.targetWorldName())) != null) {
            offset = alignedWorldOffset.scale(alignment.rightShiftAmount());
        }
        if (offset == null) {
            Location loc = context.playerLocation();
            int alignmentPower = this.worldAlignment.greatestPossibleRightShiftForWorld(context.world().getName());
            offset = Offset.align(loc.getBlockX(), loc.getBlockZ(), alignmentPower);
        }
        this.perWorldOffsetStore.put(context.player(), context.world().getName(), offset);
        return offset;
    }

    @Override
    public void onPlayerDisconnect(@NotNull UUID playerUuid) {
        this.perWorldOffsetStore.reset(playerUuid);
    }

    public ResetConfig getResetConfig() {
        return this.resetConfig;
    }

    public static class ConfigFactory
    implements OffsetProvider.ConfigurationFactory<ZeroAtLocationOffsetProvider> {
        @Override
        @NotNull
        public ZeroAtLocationOffsetProvider createProvider(@NotNull String name, @NotNull CoordinateOffset plugin, @NotNull ConfigurationSection providerConfig) throws IllegalArgumentException {
            ZeroAtLocationOffsetProvider p = new ZeroAtLocationOffsetProvider(name);
            p.resetConfig = ResetConfig.fromConfigSection(providerConfig);
            p.worldAlignment = WorldAlignmentConfig.fromConfig(providerConfig.getStringList("worldAlignment"));
            return p;
        }
    }
}

