/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider.util;

import com.jtprince.coordinateoffset.CoordinateOffset;
import com.jtprince.coordinateoffset.Offset;
import com.jtprince.lib.com.jeff_media.morepersistentdatatypes.DataType;
import com.jtprince.lib.org.jetbrains.annotations.NotNull;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public interface PerWorldOffsetStore {
    @Nullable
    default public Offset get(Player player, String worldName) {
        return this.getAll(player).get(worldName);
    }

    @NotNull
    public Map<String, Offset> getAll(Player var1);

    public void put(Player var1, String var2, Offset var3);

    public void reset(Player var1);

    public void reset(UUID var1);

    public static class Persistent
    implements PerWorldOffsetStore {
        private final NamespacedKey key;
        private final PersistentDataType<PersistentDataContainer, Map<String, Offset>> PDT_TYPE = DataType.asMap(DataType.STRING, Offset.PDT_TYPE);

        public Persistent(@NotNull NamespacedKey key) {
            this.key = key;
        }

        @Override
        @NotNull
        public Map<String, Offset> getAll(Player player) {
            Map map = (Map)player.getPersistentDataContainer().get(this.key, this.PDT_TYPE);
            if (map == null) {
                return Collections.emptyMap();
            }
            return map;
        }

        @Override
        public void put(Player player, String worldName, Offset offset) {
            HashMap<String, Offset> map = (HashMap<String, Offset>)player.getPersistentDataContainer().get(this.key, this.PDT_TYPE);
            if (map == null) {
                map = new HashMap<String, Offset>();
            }
            map.put(worldName, offset);
            player.getPersistentDataContainer().set(this.key, this.PDT_TYPE, map);
        }

        @Override
        public void reset(Player player) {
            player.getPersistentDataContainer().remove(this.key);
        }

        @Override
        public void reset(UUID playerUuid) {
            Player player = Bukkit.getPlayer((UUID)playerUuid);
            if (player != null) {
                player.getPersistentDataContainer().remove(this.key);
            } else {
                CoordinateOffset.getInstance().getLogger().warning("Failed to reset a persistent offset! Is \"persistent\" enabled at the same time as a \"resetOn\" option? (Player UUID: " + playerUuid + ")");
            }
        }
    }

    public static class Cached
    implements PerWorldOffsetStore {
        private final Map<UUID, Map<String, Offset>> playerCache = new HashMap<UUID, Map<String, Offset>>();

        @Override
        @NotNull
        public Map<String, Offset> getAll(Player player) {
            Map<String, Offset> map = this.playerCache.get(player.getUniqueId());
            if (map == null) {
                return Collections.emptyMap();
            }
            return map;
        }

        @Override
        public void put(Player player, String worldName, Offset offset) {
            if (!this.playerCache.containsKey(player.getUniqueId())) {
                this.playerCache.put(player.getUniqueId(), new HashMap());
            }
            this.playerCache.get(player.getUniqueId()).put(worldName, offset);
        }

        @Override
        public void reset(Player player) {
            this.playerCache.remove(player.getUniqueId());
        }

        @Override
        public void reset(UUID uuid) {
            this.playerCache.remove(uuid);
        }
    }
}

