/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.coordinateoffset.provider.util;

import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class WorldAlignmentConfig {
    private final List<Alignment> alignments;

    private WorldAlignmentConfig(List<Alignment> alignments) {
        this.alignments = alignments;
    }

    public static WorldAlignmentConfig fromConfig(List<String> configStringList) {
        ArrayList<Alignment> alignments = new ArrayList<Alignment>();
        for (String str : configStringList) {
            String[] tokens = str.split(":");
            alignments.add(switch (tokens.length) {
                case 2 -> new Alignment(tokens[0], tokens[1], 0);
                case 3 -> {
                    int scaleFactor = Integer.parseInt(tokens[2]);
                    Integer shift = WorldAlignmentConfig.logBaseTwoIntOrNull(scaleFactor);
                    if (shift == null) {
                        throw new IllegalArgumentException("Scale factor " + scaleFactor + " in world alignment " + str + " must be a power of 2!");
                    }
                    yield new Alignment(tokens[0], tokens[1], shift);
                }
                default -> throw new IllegalArgumentException("Badly formatted world alignment: " + str);
            });
        }
        return new WorldAlignmentConfig(alignments);
    }

    @Nullable
    public QueryResult findAlignment(String worldName) {
        for (Alignment alignment : this.alignments) {
            if (alignment.greaterWorldName.equals(worldName)) {
                return new QueryResult(alignment.lesserWorldName, -alignment.scaleShift);
            }
            if (!alignment.lesserWorldName.equals(worldName)) continue;
            return new QueryResult(alignment.greaterWorldName, alignment.scaleShift);
        }
        return null;
    }

    public int greatestPossibleRightShiftForWorld(String worldName) {
        return this.alignments.stream().filter(a -> a.greaterWorldName.equals(worldName)).max(Comparator.comparing(a -> a.scaleShift)).map(a -> a.scaleShift).orElse(0);
    }

    @Nullable
    private static Integer logBaseTwoIntOrNull(int x) {
        if (x == 0 || (x & x - 1) != 0) {
            return null;
        }
        int shifts = 0;
        while (x != 0) {
            x >>= 1;
            ++shifts;
        }
        return shifts - 1;
    }

    private record Alignment(String greaterWorldName, String lesserWorldName, int scaleShift) {
    }

    public record QueryResult(String targetWorldName, int rightShiftAmount) {
    }
}

