/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.attribute;

import com.jtprince.lib.com.github.retrooper.packetevents.protocol.attribute.Attribute;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.attribute.StaticAttribute;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.resources.ResourceLocation;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.VersionedRegistry;
import com.jtprince.lib.org.jetbrains.annotations.ApiStatus;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;

public final class Attributes {
    private static final VersionedRegistry<Attribute> REGISTRY = new VersionedRegistry("attribute", "attribute/attribute_mappings");
    public static final Attribute GENERIC_ARMOR = Attributes.define("armor", "generic", 0.0, 0.0, 30.0);
    public static final Attribute GENERIC_ARMOR_TOUGHNESS = Attributes.define("armor_toughness", "generic", 0.0, 0.0, 20.0);
    public static final Attribute GENERIC_ATTACK_DAMAGE = Attributes.define("attack_damage", "generic", 2.0, 0.0, 2048.0);
    public static final Attribute GENERIC_ATTACK_KNOCKBACK = Attributes.define("attack_knockback", "generic", 0.0, 0.0, 5.0);
    public static final Attribute GENERIC_ATTACK_SPEED = Attributes.define("attack_speed", "generic", 4.0, 0.0, 1024.0);
    public static final Attribute GENERIC_FLYING_SPEED = Attributes.define("flying_speed", "generic", 0.4, 0.0, 1024.0);
    public static final Attribute GENERIC_FOLLOW_RANGE = Attributes.define("follow_range", "generic", 32.0, 0.0, 2048.0);
    @ApiStatus.Obsolete
    public static final Attribute HORSE_JUMP_STRENGTH = Attributes.define("horse.jump_strength", null, 0.7, 0.0, 2.0);
    public static final Attribute GENERIC_KNOCKBACK_RESISTANCE = Attributes.define("knockback_resistance", "generic", 0.0, 0.0, 1.0);
    public static final Attribute GENERIC_LUCK = Attributes.define("luck", "generic", 0.0, -1024.0, 1024.0);
    public static final Attribute GENERIC_MAX_HEALTH = Attributes.define("max_health", "generic", 20.0, 1.0, 1024.0);
    public static final Attribute GENERIC_MOVEMENT_SPEED = Attributes.define("movement_speed", "generic", 0.7, 0.0, 1024.0);
    public static final Attribute ZOMBIE_SPAWN_REINFORCEMENTS = Attributes.define("spawn_reinforcements", "zombie", 0.0, 0.0, 1.0);
    public static final Attribute GENERIC_MAX_ABSORPTION = Attributes.define("max_absorption", "generic", 0.0, 0.0, 2048.0);
    public static final Attribute PLAYER_BLOCK_BREAK_SPEED = Attributes.define("block_break_speed", "player", 1.0, 0.0, 1024.0);
    public static final Attribute PLAYER_BLOCK_INTERACTION_RANGE = Attributes.define("block_interaction_range", "player", 4.5, 0.0, 64.0);
    public static final Attribute PLAYER_ENTITY_INTERACTION_RANGE = Attributes.define("entity_interaction_range", "player", 3.0, 0.0, 64.0);
    public static final Attribute GENERIC_FALL_DAMAGE_MULTIPLIER = Attributes.define("fall_damage_multiplier", "generic", 1.0, 0.0, 100.0);
    public static final Attribute GENERIC_GRAVITY = Attributes.define("gravity", "generic", 0.08, -1.0, 1.0);
    public static final Attribute GENERIC_JUMP_STRENGTH = Attributes.define("jump_strength", "generic", 0.42, 0.0, 32.0);
    public static final Attribute GENERIC_SAFE_FALL_DISTANCE = Attributes.define("safe_fall_distance", "generic", 3.0, 0.0, 1024.0);
    public static final Attribute GENERIC_SCALE = Attributes.define("scale", "generic", 1.0, 0.0625, 16.0);
    public static final Attribute GENERIC_STEP_HEIGHT = Attributes.define("step_height", "generic", 0.6, 0.0, 10.0);
    public static final Attribute GENERIC_BURNING_TIME = Attributes.define("burning_time", "generic", 0.0, 1.0, 1024.0);
    public static final Attribute GENERIC_EXPLOSION_KNOCKBACK_RESISTANCE = Attributes.define("explosion_knockback_resistance", "generic", 0.0, 0.0, 1.0);
    public static final Attribute PLAYER_MINING_EFFICIENCY = Attributes.define("mining_efficiency", "player", 0.0, 0.0, 1024.0);
    public static final Attribute GENERIC_MOVEMENT_EFFICIENCY = Attributes.define("movement_efficiency", "generic", 0.0, 0.0, 1.0);
    public static final Attribute GENERIC_OXYGEN_BONUS = Attributes.define("oxygen_bonus", "generic", 0.0, 0.0, 1024.0);
    public static final Attribute PLAYER_SNEAKING_SPEED = Attributes.define("sneaking_speed", "player", 0.3, 0.0, 1.0);
    public static final Attribute PLAYER_SUBMERGED_MINING_SPEED = Attributes.define("submerged_mining_speed", "player", 0.2, 0.0, 20.0);
    public static final Attribute PLAYER_SWEEPING_DAMAGE_RATIO = Attributes.define("sweeping_damage_ratio", "player", 0.0, 0.0, 1.0);
    public static final Attribute GENERIC_WATER_MOVEMENT_EFFICIENCY = Attributes.define("water_movement_efficiency", "generic", 0.0, 0.0, 1.0);
    public static final Attribute TEMPT_RANGE = Attributes.define("tempt_range", null, 10.0, 0.0, 2048.0);

    private Attributes() {
    }

    private static Attribute define(String key, @Nullable String legacyPrefix, double def, double min, double max) {
        return REGISTRY.define(key, data -> new StaticAttribute((TypesBuilderData)data, legacyPrefix, def, min, max));
    }

    public static VersionedRegistry<Attribute> getRegistry() {
        return REGISTRY;
    }

    public static Attribute getByName(String name) {
        String normedName = ResourceLocation.normString(name);
        if (normedName.startsWith("minecraft:generic.") || normedName.startsWith("minecraft:player.") || normedName.startsWith("minecraft:zombie.")) {
            normedName = normedName.substring(name.indexOf(46) + 1);
        }
        return REGISTRY.getByName(normedName);
    }

    public static Attribute getById(ClientVersion version, int id) {
        return REGISTRY.getById(version, id);
    }

    static {
        REGISTRY.unloadMappings();
    }
}

