/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.component.builtin.item;

import com.jtprince.lib.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Objects;

public class ItemDyeColor {
    private int rgb;
    private boolean showInTooltip;

    public ItemDyeColor(int rgb, boolean showInTooltip) {
        this.rgb = rgb;
        this.showInTooltip = showInTooltip;
    }

    public static ItemDyeColor read(PacketWrapper<?> wrapper) {
        int rgb = wrapper.readInt();
        boolean showInTooltip = wrapper.readBoolean();
        return new ItemDyeColor(rgb, showInTooltip);
    }

    public static void write(PacketWrapper<?> wrapper, ItemDyeColor color) {
        wrapper.writeInt(color.rgb);
        wrapper.writeBoolean(color.showInTooltip);
    }

    public int getRgb() {
        return this.rgb;
    }

    public void setRgb(int rgb) {
        this.rgb = rgb;
    }

    public boolean isShowInTooltip() {
        return this.showInTooltip;
    }

    public void setShowInTooltip(boolean showInTooltip) {
        this.showInTooltip = showInTooltip;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemDyeColor)) {
            return false;
        }
        ItemDyeColor that = (ItemDyeColor)obj;
        if (this.rgb != that.rgb) {
            return false;
        }
        return this.showInTooltip == that.showInTooltip;
    }

    public int hashCode() {
        return Objects.hash(this.rgb, this.showInTooltip);
    }
}

