/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.entity.wolfvariant;

import com.jtprince.lib.com.github.retrooper.packetevents.protocol.entity.wolfvariant.StaticWolfVariant;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.mapper.MappedEntitySet;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.biome.Biome;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.biome.Biomes;
import com.jtprince.lib.com.github.retrooper.packetevents.resources.ResourceLocation;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;

public interface WolfVariant
extends MappedEntity,
CopyableEntity<WolfVariant>,
DeepComparableEntity {
    public ResourceLocation getWildTexture();

    public ResourceLocation getTameTexture();

    public ResourceLocation getAngryTexture();

    public MappedEntitySet<Biome> getBiomes();

    public static WolfVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation wildTexture = new ResourceLocation(compound.getStringTagValueOrThrow("wild_texture"));
        ResourceLocation tameTexture = new ResourceLocation(compound.getStringTagValueOrThrow("tame_texture"));
        ResourceLocation angryTexture = new ResourceLocation(compound.getStringTagValueOrThrow("angry_texture"));
        MappedEntitySet<Biome> biomes = MappedEntitySet.decode(compound.getTagOrThrow("biomes"), version, Biomes.getRegistry());
        return new StaticWolfVariant(data, wildTexture, tameTexture, angryTexture, biomes);
    }

    public static NBT encode(WolfVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("wild_texture", new NBTString(variant.getWildTexture().toString()));
        compound.setTag("tame_texture", new NBTString(variant.getTameTexture().toString()));
        compound.setTag("angry_texture", new NBTString(variant.getAngryTexture().toString()));
        compound.setTag("biomes", MappedEntitySet.encode(variant.getBiomes(), version));
        return compound;
    }
}

