/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.entity.wolfvariant;

import com.jtprince.lib.com.github.retrooper.packetevents.protocol.entity.wolfvariant.StaticWolfVariant;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfVariant;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.mapper.MappedEntitySet;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.biome.Biome;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.world.biome.Biomes;
import com.jtprince.lib.com.github.retrooper.packetevents.resources.ResourceLocation;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.VersionedRegistry;
import com.jtprince.lib.org.jetbrains.annotations.ApiStatus;
import java.util.Arrays;

public final class WolfVariants {
    private static final VersionedRegistry<WolfVariant> REGISTRY = new VersionedRegistry("wolf_variant", "entity/wolf_variant_mappings");
    public static final WolfVariant PALE = WolfVariants.define("pale", "wolf", new MappedEntitySet<Biome>(Arrays.asList(Biomes.TAIGA)));
    public static final WolfVariant SPOTTED = WolfVariants.define("spotted", new MappedEntitySet<Biome>(ResourceLocation.minecraft("is_savanna")));
    public static final WolfVariant SNOWY = WolfVariants.define("snowy", new MappedEntitySet<Biome>(Arrays.asList(Biomes.GROVE)));
    public static final WolfVariant BLACK = WolfVariants.define("black", new MappedEntitySet<Biome>(Arrays.asList(Biomes.OLD_GROWTH_PINE_TAIGA)));
    public static final WolfVariant ASHEN = WolfVariants.define("ashen", new MappedEntitySet<Biome>(Arrays.asList(Biomes.SNOWY_TAIGA)));
    public static final WolfVariant RUSTY = WolfVariants.define("rusty", new MappedEntitySet<Biome>(ResourceLocation.minecraft("is_jungle")));
    public static final WolfVariant WOODS = WolfVariants.define("woods", new MappedEntitySet<Biome>(Arrays.asList(Biomes.FOREST)));
    public static final WolfVariant CHESTNUT = WolfVariants.define("chestnut", new MappedEntitySet<Biome>(Arrays.asList(Biomes.OLD_GROWTH_SPRUCE_TAIGA)));
    public static final WolfVariant STRIPED = WolfVariants.define("striped", new MappedEntitySet<Biome>(ResourceLocation.minecraft("is_badlands")));

    private WolfVariants() {
    }

    @ApiStatus.Internal
    public static WolfVariant define(String key, MappedEntitySet<Biome> biomes) {
        return WolfVariants.define(key, "wolf_" + key, biomes);
    }

    @ApiStatus.Internal
    public static WolfVariant define(String key, String assetId, MappedEntitySet<Biome> biomes) {
        return WolfVariants.define(key, ResourceLocation.minecraft("entity/wolf/" + assetId), ResourceLocation.minecraft("entity/wolf/" + assetId + "_tame"), ResourceLocation.minecraft("entity/wolf/" + assetId + "_angry"), biomes);
    }

    @ApiStatus.Internal
    public static WolfVariant define(String key, ResourceLocation wildTexture, ResourceLocation tameTexture, ResourceLocation angryTexture, MappedEntitySet<Biome> biomes) {
        return REGISTRY.define(key, data -> new StaticWolfVariant((TypesBuilderData)data, wildTexture, tameTexture, angryTexture, biomes));
    }

    public static VersionedRegistry<WolfVariant> getRegistry() {
        return REGISTRY;
    }

    static {
        REGISTRY.unloadMappings();
    }
}

