/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.item.armormaterial;

import com.jtprince.lib.com.github.retrooper.packetevents.protocol.item.armormaterial.ArmorMaterial;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.resources.ResourceLocation;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.MappingHelper;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.TypesBuilder;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import java.util.HashMap;
import java.util.Map;

public class ArmorMaterials {
    private static final Map<String, ArmorMaterial> MATERIAL_MAP = new HashMap<String, ArmorMaterial>();
    private static final Map<Byte, Map<Integer, ArmorMaterial>> MATERIAL_ID_MAP = new HashMap<Byte, Map<Integer, ArmorMaterial>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("item/item_armor_material_mappings");
    public static final ArmorMaterial LEATHER = ArmorMaterials.define("leather");
    public static final ArmorMaterial CHAINMAIL = ArmorMaterials.define("chainmail");
    public static final ArmorMaterial IRON = ArmorMaterials.define("iron");
    public static final ArmorMaterial GOLD = ArmorMaterials.define("gold");
    public static final ArmorMaterial DIAMOND = ArmorMaterials.define("diamond");
    public static final ArmorMaterial TURTLE = ArmorMaterials.define("turtle");
    public static final ArmorMaterial NETHERITE = ArmorMaterials.define("netherite");
    public static final ArmorMaterial ARMADILLO = ArmorMaterials.define("armadillo");

    public static ArmorMaterial define(String key) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        ArmorMaterial instrument = new ArmorMaterial(){

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof ArmorMaterial) {
                    return this.getName().equals(((ArmorMaterial)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, MATERIAL_MAP, MATERIAL_ID_MAP, instrument);
        return instrument;
    }

    public static ArmorMaterial getByName(String name) {
        return MATERIAL_MAP.get(name);
    }

    public static ArmorMaterial getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, ArmorMaterial> idMap = MATERIAL_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

