/*
 * Decompiled with CFR 0.152.
 */
package com.jtprince.lib.com.github.retrooper.packetevents.protocol.item.enchantment.type;

import com.jtprince.lib.com.github.retrooper.packetevents.protocol.component.EnchantEffectComponentTypes;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.component.IComponentMap;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.component.StaticComponentMap;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.item.enchantment.EnchantmentDefinition;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.item.enchantment.type.StaticEnchantmentType;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.mapper.MappedEntitySet;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.jtprince.lib.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.jtprince.lib.com.github.retrooper.packetevents.util.adventure.AdventureSerializer;
import com.jtprince.lib.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import com.jtprince.lib.net.kyori.adventure.text.Component;
import com.jtprince.lib.org.jetbrains.annotations.Nullable;
import java.util.Optional;

public interface EnchantmentType
extends MappedEntity,
CopyableEntity<EnchantmentType>,
DeepComparableEntity {
    public Component getDescription();

    public EnchantmentDefinition getDefinition();

    public MappedEntitySet<EnchantmentType> getExclusiveSet();

    public StaticComponentMap getEffects();

    public static EnchantmentType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Component description = AdventureSerializer.fromNbt(compound.getTagOrThrow("description"));
        EnchantmentDefinition definition = EnchantmentDefinition.decode(compound, version);
        MappedEntitySet exclusiveSet = Optional.ofNullable(compound.getTagOrNull("exclusive_set")).map(tag -> MappedEntitySet.decode(tag, version, EnchantmentTypes.getRegistry())).orElseGet(MappedEntitySet::createEmpty);
        StaticComponentMap effects = Optional.ofNullable(compound.getTagOrNull("effects")).map(tag -> IComponentMap.decode(tag, version, EnchantEffectComponentTypes.getRegistry())).orElse(StaticComponentMap.EMPTY);
        return new StaticEnchantmentType(data, description, definition, exclusiveSet, effects);
    }

    public static NBT encode(EnchantmentType type, ClientVersion version) {
        NBTCompound compound = (NBTCompound)EnchantmentDefinition.encode(type.getDefinition(), version);
        compound.setTag("description", AdventureSerializer.toNbt(type.getDescription()));
        if (!type.getExclusiveSet().isEmpty()) {
            compound.setTag("exclusive_set", MappedEntitySet.encode(type.getExclusiveSet(), version));
        }
        if (!type.getEffects().isEmpty()) {
            compound.setTag("effects", IComponentMap.encode(type.getEffects(), version));
        }
        return compound;
    }
}

